--
-- Copyright Roberto Andr Hexsel, 2011 
--

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- testbench para somador
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use work.p_wires.all;

entity tb_adder is
end tb_adder;

architecture TB of tb_adder is

  component adderFuncional is port(inpA, inpB : in reg16;
                          outC : out reg16;
                          vem  : in std_logic;
                          vai  : out std_logic);
  end component adderFuncional;

  component adderCadeia is port(inpA, inpB : in reg16;
                          outC : out reg16;
                          vem  : in std_logic;
                          vai  : out std_logic);
  end component adderCadeia;

  component adderAdianta4 is port(inpA, inpB : in reg16;
                          outC : out reg16;
                          vem  : in std_logic;
                          vai  : out std_logic);
  end component adderAdianta4;

  component adderAdianta16 is port(inpA, inpB : in reg16;
                          outC : out reg16;
                          vem  : in std_logic;
                          vai  : out std_logic);
  end component adderAdianta16;

  signal inpA,inpB : reg16;             -- test inputs
  signal resFun,resCad,resAd4,resAd16 : reg16; -- result
  signal vaiFun,vaiCad,vaiAd4,vaiAd16 : std_logic;
  signal addsub : std_logic;
  signal tb_res : reg16;
  signal tb_vai : std_logic;
  
  type test_record is record
                        a : reg16;
                        b : reg16;
                        f : std_logic;
                        c : reg16;
                        v : std_logic;
                      end record;
  type test_array is array(positive range <>) of test_record;
    
  constant test_vectors : test_array := (
    -- a,     b,      f,   c,    vai-um; f=0->ADD, f=1->SUB
    --ADD
    (x"0000",x"0000",'0',x"0000",'0'),
        (x"0001",x"FFFF",'0',x"0000",'1'),
            (x"0001",x"FFFF",'0',x"0000",'1'),
    (x"8000",x"8000",'0',x"0000",'1'),
    (x"5500",x"0055",'0',x"5555",'0'),
    (x"aa00",x"00aa",'0',x"aaaa",'0'),
    (x"aa55",x"55aa",'0',x"ffff",'0'),
    (x"3FFF",x"0001",'0',x"4000",'0'),
    (x"0000",x"0000",'0',x"0000",'0'),
    (x"7FFF",x"0001",'0',x"8000",'0'),
    (x"0042",x"0042",'0',x"0084",'0'),
    (x"0001",x"FFFF",'0',x"0000",'1'),
    (x"2400",x"2400",'0',x"4800",'0'),
    (x"FFFF",x"FFFF",'0',x"FFFE",'1'),
    (x"0440",x"0220",'0',x"0660",'0'),
    (x"aaaa",x"5555",'0',x"ffff",'0'),
    (x"aaaa",x"5556",'0',x"0000",'1'),
    (x"aaaa",x"5557",'0',x"0001",'1'),
    (x"aa55",x"55ab",'0',x"0000",'1'),
    -- SUB
    (x"0000",x"0000",'1',x"0000",'1'),  -- inverte vai-um (empresta)
    (x"8000",x"8000",'1',x"0000",'1'),
    (x"5555",x"aaaa",'1',x"aaab",'0'),
    (x"aaaa",x"5555",'1',x"5555",'1'),
    (x"aa55",x"55aa",'1',x"54ab",'1'),
    (x"ffff",x"0001",'1',x"fffe",'1'),
    (x"0001",x"ffff",'1',x"0002",'0'),
    (x"8000",x"7fff",'1',x"0001",'1'),
    (x"8001",x"7fff",'1',x"0002",'1'),
    (x"8000",x"7ffe",'1',x"0002",'1'),
    (x"8001",x"7ffe",'1',x"0003",'1')
    );

begin  -- TB

  U_addFun: adderFuncional port map ( inpA, inpB, resFun, addsub, vaiFun );
  
  U_addCad: adderCadeia port map ( inpA, inpB, resCad, addsub, vaiCad );

  U_addAd4: adderAdianta4 port map ( inpA, inpB, resAd4, addsub, vaiAd4 );

  U_addAd16: adderAdianta16 port map ( inpA, inpB, resAd16, addsub, vaiAd16 );
  
  U_testValues: process                -- test the circuit
    variable v : test_record;
  begin
    
    for i in test_vectors'range loop
      v := test_vectors(i);
      inpA <= v.a;
      if v.f = '0' then                 -- soma
        inpB <= v.b;
      else
        inpB <= not(v.b);               -- subtração= A + not(B)+1
      end if;
      addsub <= v.f;                    -- vem-um(0)=1 na subtração
      tb_res <= v.c;
      tb_vai <= v.v;
      --assert resFun = tb_res report "valor errado" severity error;
      --assert vaiFun = tb_vai report "vai-um errado" severity error;
      --assert resCad = tb_res report "valor errado" severity error;
      --assert vaiCad = tb_vai report "vai-um errado" severity error;
      --assert resAd4 = tb_res report "valor errado" severity error;
      --assert vaiAd4 = tb_vai report "vai-um errado" severity error;
      --assert resAd16 = tb_res report "valor errado" severity error;
      --assert vaiAd16 = tb_vai report "vai-um errado" severity error;
      wait for 1000 ns;
    end loop;

    wait;
    end process;
   
end TB;

----------------------------------------------------------------
configuration CFG_TB of TB_ADDER is
	for TB
        end for;
end CFG_TB;
----------------------------------------------------------------
