echo "the installation will take place in the current folder."
echo ""
echo "path to 'ns-allinone-2.30.tar.gz' (do not rename the file, "
echo "or leave it blank in order to download it from the internet):"
read pth
pth=$(echo $pth | sed 's/\/ns-allinone-2.30\.tar\.gz//g')

if [ -f $pth/ns-allinone-2.30.tar.gz ]
then
	echo "Copying.."
	cp $pth/ns-allinone-2.30.tar.gz .
else
	echo "Downloading file.."
	wget http://www.isi.edu/nsnam/dist/ns-allinone-2.30.tar.gz
fi

echo "Unpacking.."
tar -xzf ns-allinone-2.30.tar.gz

echo "Generating config file.."
sed -e "s/XXXX/$(echo $PWD | sed -e 's/\//\\\//g')/g" ./ns2rc > ~/.ns2rc_RRUCR

for i in $(ls | grep \.patch)
do
	patch -p1 -i $i
done

cd ns-allinone-2.30
echo "Copying protocol agent.."
cp -r ../RRUCR/ ./ns-2.30/
echo "Copying test tcl files.."
cp -r ../RRUCR-Tcl/ ./ns-2.30/tcl/ex/
echo "Installing.."
./install

echo "Sourcing config files.."
source ~/.ns2rc_RRUCR
echo "Including config files sourcing to ~/.bashrc"
echo "[ -f ~/.ns2rc_RRUCR ] && source ~/.ns2rc_RRUCR" >> ~/.bashrc

echo "In order to teste the protocol, type "
echo "ns EX-RRUCR-Grid.tcl, inside the folder ns-2.30/tcl/ex/RRUCR-Tcl"
