/* number of 'mapped' potences from chipcon CC1000 datasheet */
#define num_pot 22

/* Pt_ and Pt_consume_ values based on tinyOS TP */
#define Pt_02 0.01000e-3
#define Pt_03 0.01584e-3
#define Pt_04 0.02511e-3
#define Pt_05 0.03162e-3
#define Pt_06 0.05011e-3
#define Pt_07 0.06309e-3
#define Pt_08 0.07943e-3
#define Pt_09 0.10000e-3
#define Pt_0b 0.12589e-3
#define Pt_0c 0.15848e-3
#define Pt_0d 0.19952e-3
#define Pt_0f 0.25118e-3
#define Pt_40 0.31622e-3
#define Pt_50 0.39810e-3
#define Pt_60 0.63095e-3
#define Pt_70 0.79432e-3
#define Pt_80 1.00000e-3
#define Pt_90 1.25892e-3
#define Pt_b0 1.58489e-3
#define Pt_c0 1.99526e-3
#define Pt_f0 2.51188e-3
#define Pt_ff 3.16227e-3

#define Pt_consume_02 25.8e-3
#define Pt_consume_03 27.0e-3
#define Pt_consume_04 27.3e-3
#define Pt_consume_05 27.9e-3
#define Pt_consume_06 28.5e-3
#define Pt_consume_07 29.1e-3
#define Pt_consume_08 29.7e-3
#define Pt_consume_09 30.3e-3
#define Pt_consume_0b 31.2e-3
#define Pt_consume_0c 31.8e-3
#define Pt_consume_0d 32.4e-3
#define Pt_consume_0f 33.3e-3
#define Pt_consume_40 41.4e-3
#define Pt_consume_50 43.5e-3
#define Pt_consume_60 45.3e-3
#define Pt_consume_70 47.4e-3
#define Pt_consume_80 50.4e-3
#define Pt_consume_90 51.6e-3
#define Pt_consume_b0 55.5e-3
#define Pt_consume_c0 57.6e-3
#define Pt_consume_f0 63.9e-3
#define Pt_consume_ff 76.2e-3



double Pt_array_[num_pot] = {
  Pt_02, Pt_03, Pt_04, Pt_05, Pt_06,
  Pt_07, Pt_08, Pt_09, Pt_0b, Pt_0c,
  Pt_0d, Pt_0f, Pt_40, Pt_50, Pt_60,
  Pt_70, Pt_80, Pt_90, Pt_b0, Pt_c0,
  Pt_f0, Pt_ff
};

double Pt_consume_array_[num_pot] = {
  Pt_consume_02, Pt_consume_03, Pt_consume_04, Pt_consume_05, Pt_consume_06,
  Pt_consume_07, Pt_consume_08, Pt_consume_09, Pt_consume_0b, Pt_consume_0c,
  Pt_consume_0d, Pt_consume_0f, Pt_consume_40, Pt_consume_50, Pt_consume_60,
  Pt_consume_70, Pt_consume_80, Pt_consume_90, Pt_consume_b0, Pt_consume_c0,
  Pt_consume_f0, Pt_consume_ff
};
