#include "RRUCR.h"

void RRUCRAgent::HandlePOT_ANS(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	#ifdef DEBUG_MYUNEQ
	fprintf(stderr,"recebi POT_ANS %d\n",hdr->data1);
	#endif
	RFMinG_ = (hdr->data1<RFMinG_ ? hdr->data1 : RFMinG_);
	RFMaxG_ = (hdr->data1>RFMaxG_ ? hdr->data1 : RFMaxG_);
	if (hdr->data2<shorterRE.v) {
		shorterRE.v	= hdr->data2;
		shorterRE.id = cmh->prev_hop_;
	}
	if (hdr->data2>higherRE.v) {
		higherRE.v	= hdr->data2;
		higherRE.id = cmh->prev_hop_;
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleINCR_POT(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (!pot_answered){
		#ifdef LABEL
		setLabel("r",hdr->data1);
		#endif
		RBase = hdr->data1;
		setRFPower(hdr->data1);
		hdr->type = POT_ANS;
		hdr->data2= myEnergy();
		initPkt(pkt,BASE_STATION_.id);	
		send(pkt,0);
		pot_answered=true;
	}

}

/* ----------------------------------------------------------------------------------------------------------- */
void RRUCRAgent::HandleSETUP_CONFIG(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (!sentStp) {
		if (hdr->data2 != -1) {
			RFMin = hdr->data1;
			RFMax = (int) hdr->data2;
			Raio	= (int) ((float)(1 - (float)(RFMax - RBase)/(RFMax==RFMin?1:RFMax-RFMin)) * POT_LIMIT);
			Raio	= Raio>POT_LIMIT?POT_LIMIT:Raio;
			#ifdef DEBUG_MYUNEQ
			printf("RFMin: %d, RFMax: %d, RBase: %d, Raio de %d eh %d\n",RFMin,RFMax,RBase,me(),Raio);
			#endif
			cmh->prev_hop_	= me();
			cmh->direction()= hdr_cmn::UP; /* in order to send efectively */
			hdr->data1=1;
			hdr->data2=-1;
			if (RBase==RFMax || RFMax==-2)
				send(pkt,0);
			ct_.sched(3.0); /* essa coisa aqui que vai cuidar de formar os clusteres */
		} else { /* alguem tá repassando */
			Raio	= (POT_LIMIT + hdr->data1/2/*FIXME?*/<=POT_MAX_GLOBAL?POT_LIMIT + hdr->data1:POT_MAX_GLOBAL);
			Raio	= Raio>POT_MAX_GLOBAL?POT_MAX_GLOBAL:Raio;
			RBase = 21/*POT_LIMIT*/ + hdr->data1;
			#ifdef DEBUG_MYUNEQ
			printf("--RFMin: %d, RFMax: %d, RBase: %d, Raio de %d eh %d\n",RFMin,RFMax,RBase,me(),Raio);
			#endif
			setRFPower(SETUPP);
			#ifdef LABEL
			setLabel("r",POT_LIMIT+hdr->data1);
			#endif
			cmh->prev_hop_	= me();
			cmh->direction()= hdr_cmn::UP; /* in order to send efectively */
			hdr->data1 = hdr->data1 + 1;
			hdr->data2 = -1;
			if (RFMax==-2)
				send(pkt,0);
			ct_.sched((3.0-(TIMER*0.1*hdr->data1)>0)?3.0-(TIMER*0.1*hdr->data1):0.0); /* essa coisa aqui que vai cuidar de formar os clusteres */
		}
		sentStp=true;
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleCOMPETE_HEAD(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	SCH.v = (volt*) realloc(SCH.v,sizeof(volt)*(SCH.tam+1));
	SCH.v[SCH.tam].id=cmh->prev_hop_;
	SCH.v[SCH.tam].v=hdr->data2;
	SCH.v[SCH.tam].r=pkt->myRSSI;
	SCH.tam++;

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleFINAL_HEAD(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	finals++;
	beTentativeHead--;
	if (beTentativeHead<4) {
		if (beTentativeHead==3) {
			#ifdef EVALUATE_MYUNEQ
			Gnum_clus--;
			#endif
			printf("%d aborted\n",me());
		}
		#ifdef COLORU
		setColor("yellow");
		#endif
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleCH_ADV(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

		if (beTentativeHead<=1) {
			#ifdef COLORU
			setColor("black");
			#endif
			SCH.v = (volt*) realloc(SCH.v,sizeof(volt)*(SCH.tam+1));
			SCH.v[SCH.tam].id=cmh->prev_hop_;
			SCH.v[SCH.tam].r=hdr->data1;
			SCH.v[SCH.tam].v=pkt->myRSSI;
			SCH.tam++;
		}
}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleJOIN_CLUSTER(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (hdr->data2 < shorterRE.v) {
		shorterRE.v	= hdr->data2;
		shorterRE.id = cmh->prev_hop_;
	}
	if (hdr->data2 > higherRE.v) {
		higherRE.v	= hdr->data2;
		higherRE.id = cmh->prev_hop_;
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleBEACON_ROUTE(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (hdr->data1<=wave) {
		if (isCH()) {
			#ifdef COLORU
			setColor("orange");
			#endif
			rd2 = rand()%20;
			counter2 = 0;
			if (next.v < pkt->myRSSI || wave > hdr->data1) {
				wave = hdr->data1;
				next.r	= pkt->myRSSI;
				next.id = cmh->prev_hop_;
				#ifdef DEBUG_MYUNEQ
				printf("***next de %d eh %d\n",me(),next.id);
				#endif
			}
			rt_.force_cancel();
			rt_.sched(hdr->data2);
		} else if (wave> hdr->data1) {
			wave=hdr->data1;
		}
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleROTATE_CH(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (next.id == cmh->prev_hop_) {
		if (!isCH()) {
			if (myEnergy() > hdr->data2) {
				rcht_.sched((rand()%20)*TIMER);
			}
		} else {
			makeNewRoute=true;
		}
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleENERGY_DATA(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (hdr->data1 == me()) {
		#ifdef DEBUG_MYUNEQ
		fprintf(stderr,"%d told me(%d) his energy:%f\n",cmh->prev_hop_,me(),hdr->data2);
		#endif
		rotate_ok=true;
		if (hdr->data2 > higherRE.v) {
			higherRE.v	= hdr->data2;
			higherRE.id = cmh->prev_hop_;
		}
	} else {
		if (hdr->data1 == next.id && myEnergy()<hdr->data2) {
			rcht_.force_cancel();
		}
	}

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleDENOMINATE_CH(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	makeNewRoute=true;
	#ifdef EVALUATE_MYUNEQ
	Gwave_clus[Raio]++;
	Gnum_rotateds++;
	#endif
	beTentativeHead=6;
	higherRE.v=myEnergy();//hdr->data2;
	next.id=hdr->next;
	wave=hdr->data1;
	#ifdef DEBUG_MYUNEQ
	fprintf(stderr,"i am new CH %d, old was %d\n",me(),cmh->prev_hop_);
	printf("__%d new CH, old was %d\n",me(),cmh->prev_hop_);
	#endif
	#ifdef COLORU
	if (colorize)
		setColor("black");
	#endif
	setLabel("_CH_",me());
	hdr->data1			= cmh->prev_hop_;
	initPkt(pkt,IP_BROADCAST);
	hdr->type				= INFORM_NEW_CH;
	setRFPower(INTERCP);
	send(pkt,0);

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleINFORM_NEW_CH(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	if (next.id==hdr->data1) {
		#ifdef DEBUG_MYUNEQ
		fprintf(stderr,"%d know about new CH %d\n",me(),cmh->prev_hop_);	
		#endif
		next.id=cmh->prev_hop_;
		#ifdef LABEL
		if (beTentativeHead<=0) {
			setLabel("j",next.id);
		}
		#endif
	} 

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::HandleDATA_GATHERED(Packet *pkt, hdr_cmn *cmh, hdr_RRUCR *hdr){

	/* FIXME essa parte 'arruma' a árvore */
	if ((float)(wave+((float)RBase/100)) > hdr->data2 && isCH() && hdr->next != me()) { 

		// levar em consideracao o RSSI tb? se for ficar mto mais fraco melhor deixar quieto..
		if (makeNewRoute /*&& wave > hdr->data2 && hdr->data2 >= wave-1*/) {

			next.id			= cmh->prev_hop_;
			printf("__%d atualizou next por causa de rotação para %d(%f->%f)(minha wave: %d)\n",me(),next.id,routeCost,hdr->data2,wave);
			routeCost		= hdr->data2;
			makeNewRoute = false;

		} else if (hdr->data2 < routeCost /*&& wave > hdr->data2 && hdr->data2 >= wave-1*/) {

			next.id	 = cmh->prev_hop_;
			printf("__%d atualizou next por causa que a rota é melhor para %d(%f<%f)\n",me(),next.id,hdr->data2,routeCost);
			routeCost = hdr->data2;

		}

	}
	
	if (isCH() && next.id == -1 && hdr->data2 != INF)
		next.id = cmh->prev_hop_;

	if (me()!=BASE_STATION_.id && hdr->next==me()) {

		#ifdef DEBUG_MYUNEQ
		printf("noh %d recebeu pacote %d, encaminhando para %d (w: %d\n",me(),cmh->uid(),next.id,wave);
		printf("noh %d tem energia %f e o maior do cluster tem energia %f\n",me(),myEnergy(),higherRE.v);

		if (lastPkt == cmh->uid()) {
			printf("__LOOP- noh %d recebeu pacote %d de novo, de %d\n",me(),cmh->uid(),cmh->prev_hop_);
		}
		#endif
		hdr->data2=(float)(wave+((float)RBase/100));
		hdr->next=next.id;
		initPkt(pkt,IP_BROADCAST);//next.id);
		setRFPower(INTERCP);

		if (next.id != -1 && lastPkt!=cmh->uid()) {
			send(pkt,0);
			lastPkt=cmh->uid();
		} 

	} else if (me()==BASE_STATION_.id && hdr->next==me()) {

		#ifdef DEBUG_MYUNEQ
		printf("oooBASE recebeu pacote %d! %d %f \n",cmh->uid(),hdr->data1,hdr->data2);
		#endif
		#ifdef EVALUATE_MYUNEQ
		Greceived_pkts++;
		#endif

	}

}


/* ----------------------------------------------------------------------------------------------------------- */
