#ifndef ns_RRUCR_h
#define ns_RRUCR_h

/* evaluation debugs */
#define EVALUATE_MYUNEQ
/* funcionality debugs */
#define DEBUG_MYUNEQ
/* make color functions available -- nam purpposes */
#define COLORU
/* enable majority of labels -- nam purpposes */
#define LABEL

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <signal.h>
#include <float.h>
#include <stdlib.h>
#include <list>
#include <timer-handler.h>

#include "agent.h"
#include "tclcl.h"
#include "packet.h"
#include "address.h"
#include "ip.h"
#include "config.h"
#include "trace.h"
#include "node.h"
#include "mobilenode.h"
#include "tworayground.h"

//#include "potences.h"
#include "types.h"
#include "auxiliar_structures.h"
#include "timers.h"
#include "colors.h"
#include "definitions.h"

extern int RFMinG_,RFMaxG_;
extern no_ BASE_STATION_;
extern int Gnum_clus,Gwave_clus[],Gnum_rotateds,Greceived_pkts;
extern bool colorize;
extern double Pt_array_[], Pt_consume_array_[];


#define THIS_NODE    here_.addr_
#define TIMER 0.050
#define INF 99999
#define MYZERO 0.0001


struct hdr_RRUCR {
  int type,
	data1,
	next;
	float data2;

	static int offset_;
  inline static int& offset(){
    return offset_; 
  }
  inline static hdr_RRUCR* access(const Packet* p){
    return (hdr_RRUCR*) p->access(offset_);
  }
};

class RRUCRAgent : public Agent {

 friend class DebugTimer_;
 friend class RouteTimer_;
 friend class CountTimer_;
 friend class SetupTimer_;
 friend class RotateTimer_;

 public:

	void HandleSETUP_CONFIG(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleINCR_POT(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandlePOT_ANS(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleCOMPETE_HEAD(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleFINAL_HEAD(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleCH_ADV(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleJOIN_CLUSTER(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleBEACON_ROUTE(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleROTATE_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleENERGY_DATA(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleDENOMINATE_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleINFORM_NEW_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
	void HandleDATA_GATHERED(Packet*,hdr_cmn*,hdr_RRUCR*);

	void GenerateData();

  void recv(Packet*, Handler*);
  void RRUCRrecv(Packet*);
	void Op1();
	void RollCompeteHead();
	void JoinCompetition();
	void CheckHigherEnergyToBecomePrimaryFinalHead();
	void BecomeSecondaryFinalHead();
	void CheckClustersDensity();
	void AdvertiseCH();
	void JoinClosestCluster();
	void CheckForFailures();
	void AskRotation();
	void Rotate();
	void EndConfig();
	float distBase();
  int command(int argc, const char*const* argv);
	void setRFPower(int);
	void setColor(char*);
	void setLabel(char*,int);
	int initPkt(Packet*,int);
	int counter,counter2,rd,rd2,beTentativeHead,finals,wave,waveCounter,lastPkt;
	float routeCost;
  bool sentStp,allOk,rotate,rotate_ok,jaSai,pot_answered,makeNewRoute;
  RRUCRAgent();

	double myEnergy();

	int me(){
		return myaddr_;
	};
	
	bool isCH(){
		if (beTentativeHead>=4) return true;
		return false;
	};

 protected:
	DebugTimer_ dt_;
	RouteTimer_ rt_;
  SetupTimer_ mt_;
	CountTimer_ ct_;
	RotateTimer_ rcht_;
	MobileNode *node;
  lista SCH;
  int myaddr_,pBeTHead_;
	volt next,shorterRE,higherRE;
  Trace *tracetarget;
	int RFMin, RFMax, RBase,Raio,pData;
	int MAX_ROTATE, MAX_RECV;

};



#endif
