#include "RRUCR.h"
/* ----------------------------------------------------------------------------------------------------------- */
/* This function returns the distance of the current node
 * to the base-station */
float RRUCRAgent::distBase(){
  node=(MobileNode*) MobileNode::get_node_by_address(me());
  float dX = BASE_STATION_.x - node->X();
  float dY = BASE_STATION_.y - node->Y();
  dX*=dX;
  dY*=dY;
  return (sqrt(dX+dY));
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Initializes packet common structures before sending it */
int RRUCRAgent::initPkt(Packet *p,int Next) {
  hdr_cmn *cmh = HDR_CMN(p);
  cmh->addr_type()= NS_AF_INET;
  cmh->prev_hop_ = me();
  cmh->direction()= hdr_cmn::DOWN;
  cmh->next_hop()= Next; // IP_BROADCAST;
  return cmh->uid();
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Set a label for the current node
 * FIXME: labels usually appear in green, that is annoying */
void RRUCRAgent::setLabel(char *label,int id) {
  Tcl& tcl = Tcl::instance();

  tcl.evalf("%s set node_", name());
  const char *node_object = tcl.result();
  char id_[4];
  if (id!=-1) {
    sprintf(id_,"%d",id);
    Tcl::instance().evalf("%s label \"%s(%s)\"", node_object, label,id_);
  } else {
    Tcl::instance().evalf("%s label \"%s\"", node_object, label);
  }
}

/* ----------------------------------------------------------------------------------------------------------- */
/* returns current energy of the current node */
double RRUCRAgent::myEnergy(){
  node=(MobileNode*) MobileNode::get_node_by_address(me());
  return (node->energy_model()->energy());
}


/* ----------------------------------------------------------------------------------------------------------- */
/* Set current node's color, for nam visualization */
void RRUCRAgent::setColor(char *color) {
  Tcl& tcl = Tcl::instance();
  tcl.evalf("%s set node_", name());
  const char *node_object = tcl.result();
  Tcl::instance().evalf("%s color %s", node_object, color);
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Set the TX power value, according to a potence index */
void RRUCRAgent::setRFPower(int pow) {
  Tcl &tcl = Tcl::instance();
  tcl.evalf("[[%s set node_] set netif_(0)] set Pt_ %f",name(),Pt_array_[pow]);
  tcl.evalf("[[%s set node_] set netif_(0)] set Pt_consume_ %f",name(),Pt_consume_array_[pow]);
}
