#ifndef ns_RRUCR_h
#define ns_RRUCR_h

/* evaluation debugs */
#define EVALUATE_MYUNEQ
/* funcionality debugs */
#define DEBUG_MYUNEQ
/* make color functions available -- nam purpposes */
#define COLORU
/* enable majority of labels -- nam purpposes */
#define LABEL

/* ----------------------------------------------------------------------------------------------------------- */

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <signal.h>
#include <float.h>
#include <stdlib.h>
#include <list>
#include <timer-handler.h>

#include "agent.h"
#include "tclcl.h"
#include "packet.h"
#include "address.h"
#include "ip.h"
#include "config.h"
#include "trace.h"
#include "node.h"
#include "mobilenode.h"
#include "tworayground.h"

#include "types.h"
#include "auxiliar_structures.h"
#include "timers.h"
#include "colors.h"
#include "definitions.h"

/* ----------------------------------------------------------------------------------------------------------- */
/* These variables are used in several .cc files that include RRUCR.h,
   their definition in located at RRUCR.cc */
extern vetorCores vColor;
extern int RFMinG_,RFMaxG_;
extern no_ BASE_STATION_;
extern int Gnum_clus,Gwave_clus[],Gnum_rotateds,Greceived_pkts,Gnode_rays[],Gr_max,Gd_nodes;
extern bool colorize;
extern double Pt_array_[], Pt_consume_array_[];

/* ----------------------------------------------------------------------------------------------------------- */
/* Constant definitions */
#define TIMER 0.050
#define INF 99999
#define MYZERO 0.0001

/* ----------------------------------------------------------------------------------------------------------- */
/* Routing protocol header */
struct hdr_RRUCR {
  int type, // type of the message
  data1,
  next; // next hop of the message
  float data2;

  static int offset_;
  inline static int& offset(){
    return offset_; 
  }
  inline static hdr_RRUCR* access(const Packet* p){
    return (hdr_RRUCR*) p->access(offset_);
  }
};

/* ----------------------------------------------------------------------------------------------------------- */
/* Routing protocol agent */
class RRUCRAgent : public Agent {

 /* timers are defined as friend classes, in order to access this class
    functions and variables through a pointer to an object instance */
 friend class DebugTimer_; // timer responsible for printing debugging & evaluation info
 friend class RouteTimer_; // timer responsible for initial backbone creation
 friend class CountTimer_; // timer responsible for main operations of all non-sink nodes
 friend class SetupTimer_; // timer responsible for sink operations
 friend class RotateTimer_; // timer that helps in rotation, used for ordinary nodes to send energy data

 public:
  RRUCRAgent(); // constructor of the class: variable initializations & bindings

 protected:
  double myEnergy(); // returns value of current energy
  float distBase(); // returns the distance to the sink
  void setRFPower(int); // set Tx power according to an index
  void setColor(char*); // set color
  void setLabel(char*,int); // set label
  int initPkt(Packet*,int); // initialize a packet with common parameters, returns ID of the packet

  int me(){
    return myaddr_;
  }; // returns node's address
  
  bool isCH(){
    if (beTentativeHead>=4)
      return true;
    return false;
  }; // returns true if the node is a CH

  int counter,         // |  
      counter2,        // |_ used for general operations, i.e. timers management
      rd,              // |
      rd2,             // |

      beTentativeHead, // how strong CH am I? used for determining CHs
      finals,          // number of FINAL_HEAD msgs i heard
      wave,            // in which wave am i? how distant from the sink
      lastPkt,         // ID of the last pkt sent, used for detecting loops
      myaddr_,         // my address
      pBeTHead_,       // probability to enter competition for CH
      RFMin,           // minimum Tx power used in the WSN
      RFMax,           // maximum "  "     "    "  "   "
      RBase,           // Txpower used to reach the sink
      Raio;            // Competition scope

  float routeCost;      // cost of node's route to the sink
 
  bool sentStp,        // has the sink sent SETUP_CONFIG? can i start the clustering process?
        allOk,          // clustering ok?
       rotate,         // must I rotate?
       rotate_ok,      // did i find a node to become a new CH?
       jaSai,          // was my death already computed?
       pot_answered,   // have I already answered one POT_ANS?
       makeNewRoute;   // must I create a new route?


  lista SCH;       // used for keeping some ino on neighbor nodes on some operations

  volt next,       // next node in route
       shorterRE,  // node with less energy
       higherRE;   // node with more energy

  Trace *tracetarget;

  MobileNode *node;

 private:
  DebugTimer_ dt_;    // timer responsible for printing debugging & evaluation info
  RouteTimer_ rt_;    // timer responsible for initial backbone creation
  SetupTimer_ mt_;    // timer responsible for main operations of all non-sink nodes
  CountTimer_ ct_;    // timer responsible for sink operations
  RotateTimer_ rcht_; // timer that helps in rotation, used for ordinary nodes to send energy data

  int command(int argc, const char*const* argv); // how to handle functions passed on tcl

  /* recv functions for general packets, and protocol specific */
  void recv(Packet*, Handler*);
  void RRUCRrecv(Packet*);

  /* how to handle each type of msg */
  void HandleSETUP_CONFIG(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleINCR_POT(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandlePOT_ANS(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleCOMPETE_HEAD(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleFINAL_HEAD(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleCH_ADV(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleJOIN_CLUSTER(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleBEACON_ROUTE(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleROTATE_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleENERGY_DATA(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleDENOMINATE_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleINFORM_NEW_CH(Packet*,hdr_cmn*,hdr_RRUCR*);
  void HandleDATA_GATHERED(Packet*,hdr_cmn*,hdr_RRUCR*);

  /* Clustering operations */
  void Op1();
  void RollCompeteHead();
  void JoinCompetition();
  void CheckHigherEnergyToBecomePrimaryFinalHead();
  void BecomeSecondaryFinalHead();
  void CheckClustersDensity();
  void AdvertiseCH();
  void JoinClosestCluster();
  void CheckForFailures();
  void AskRotation();
  void Rotate();
  void EndConfig();
  void GenerateData();

};



#endif
