#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <signal.h>
#include <float.h>
#include <stdlib.h>
#include <tcl.h>

#include "RRUCR.h"
#include "potences.h"

/* FIXME: there must be a way to eliminate global RFMaxG_ and RFMinG_, they
 * are not really necessary */
int RFMinG_=25,RFMaxG_=-2;

/* BASE_STATION's id and coordinates, in order to calculate distance.
 * obs.: This distance is used for pure debugging, no routing need this */
no_ BASE_STATION_;

int hdr_RRUCR::offset_;


/* evaluation debugs */
#define EVALUATE_MYUNEQ

/* funcionality debugs */
#define DEBUG_MYUNEQ

/* make color functions available -- nam purpposes */
#define COLORU

/* enable majority of labels -- nam purpposes */
#define LABEL

/* evaluation global variables */
#ifdef EVALUATE_MYUNEQ
/* total energy of the network */
double Gtotal_energy=0;
/* counter that determines what to do in some loops */
int Genergy_counter=0;
/* number of current alive nodes */
int Galive_nodes=0;
/* number of all sent data packets */
int Gsent_packets=0;
/* number of received data packets */
int Greceived_pkts=0;
/* number of rotations */
int Gnum_rotateds=0;
/* number of clusters */
int Gnum_clus=0;
/* number of the highest wave in hops */
int Gwave_max=0;
/* number of nodes withou coverage */
int Gd_nodes=0;
/* number of clusters per wave */
int Gwave_clus[100];
/* numer of nodes per ray of actuation */
int Gnode_rays[num_pot];
/* maximum ray of actuation */
int Gr_max=0;
/* number of failures to occur, based on the node's ray */
int Gfailures[100];
/* set that failures are to occur */
bool Gfailure;
/* distance of the farthest node to the base */
float Gfarthest_ = 0.0;
/* slices of failure, based on the farthest node to the base distance */
double wd1_,wd2_,wd3_;
/* number of nodes per slice */
int w1_=0,w2_=0,w3_=0,w4_=0;
#endif

#ifdef COLORU
/* colors vector, responsible for nam coloring based on clusters */
vetorCores vColor;
bool colorize=false;
#endif

/* ----------------------------------------------------------------------------------------------------------- */

static class RRUCRHeaderClass : public PacketHeaderClass {
public:
  RRUCRHeaderClass() : PacketHeaderClass("PacketHeader/RRUCR", sizeof(hdr_RRUCR)) {
    bind_offset(&hdr_RRUCR::offset_);
  }
} class_RRUCRhdr;

/* ----------------------------------------------------------------------------------------------------------- */

static class RRUCRClass : public TclClass {
public:
  RRUCRClass() : TclClass("Agent/RRUCR") {}
  TclObject* create(int, const char*const*) {
    return (new RRUCRAgent());
  }
} class_RRUCR;

/* ----------------------------------------------------------------------------------------------------------- */

RRUCRAgent::RRUCRAgent() : Agent(PT_RRUCR), dt_(this),rt_(this), mt_(this), ct_(this), rcht_(this)
{
  /* counter used to control some timers effects */
  counter=0;
  /* counter used to control some timers effects */
  counter2=0;
  /* the cost of the currently used route */
  routeCost=0;
  /* minimum ray used on the network */
  RFMin=25;
  /* maximum ray used on the network */
  RFMax=-2;
  /* minimum ray necessary to get to the base station */
  RBase=-1;
  /* am I already dead, and already computed my death? */
  jaSai=false;
  /* Have I found someone to rotate with? */
  rotate_ok=false;
  /* Have I already answered an INCR_POT message? */
  pot_answered=false;
  /* Has the SETUP messaage already been sent? */
  sentStp=false;
  /* clusters Ok and backbone created? */
  allOk=false;
  /* must I rotate? */
  rotate=false;
  /* must I create a new route? */
  makeNewRoute=false;
  /* node status, if I am to try to be a cluster-head,
   * if I already AM a cluster-head, how strung CH am I, etc */
  beTentativeHead=0;
  /* node object */
  node = NULL;
  /* size of the SCH list */
  SCH.tam=0;
  /* list used for various purpposes, such as guarding neighbors, 
   * adjacent CHs, etc */
  SCH.v = (volt*) malloc(sizeof(volt));
  /* energy of my next hop */
  next.v = 0;
  /* last sent packet ID -- to prevent sending again the same packet
   * in case a loop has been generated */ 
  lastPkt=0;
  /* it's use varies according to the situation */
  next.r = 0;
  /* energy remaining on the node with less energy */
  shorterRE.v=INF;
  /* energy remaining on the none with the highest energy */
  higherRE.v=0;
  /* how many final_head's packets have I received? */
  finals=0;
  /* in which wave am I? */
  wave=INF;

  bind("packetSize_", &size_);
  bind("clusterProb_", &pBeTHead_);
  bind("Master_", &next.id);

  #ifdef EVALUATE_MYUNEQ
  for (int i=0;i<num_pot;i++) {
    Gnode_rays[i]=0;
    Gwave_clus[i]=0;
    Gfailures[i]=0;
  }
  for (int i=num_pot;i<100;i++) {
    Gwave_clus[i]=0;
    Gfailures[i]=0;
  }
  #endif
}



/* ----------------------------------------------------------------------------------------------------------- */
/* timer used to collect evaluation data */
void DebugTimer_::expire(Event *) {
  #ifdef EVALUATE_MYUNEQ
  if (a_->me() == BASE_STATION_.id) {
    Genergy_counter++;
    if (Genergy_counter==5){
      printf("Ws:%d:%d:%d:%d\n",w1_,w2_,w3_,w4_);
      printf("Gsent_packets:%d:Greceived_pkts:%d:Gtotal_energy:%f:Galive_nodes:%d:Gnum_clus:%d:Gnum_rotateds:%d:Gd_nodes:%d\n",
                                      Gsent_packets,Greceived_pkts,Gtotal_energy,Galive_nodes,Gnum_clus,Gnum_rotateds,Gd_nodes);
      if (Gwave_max==0) printf("wave:0:0:");
      else for (int i=0;i<Gwave_max;i++)
        printf("wave:%d:%d:",i,Gwave_clus[i]);
      printf("\n");
      if (Gr_max == 0) printf("raio:0:0:");
      else for (int i=0;i<Gr_max;i++)
        printf("raio:%d:%d:",i,Gnode_rays[i]);
      printf("\n");
      /* resets counter and total energy */
      Gtotal_energy=0;
      Genergy_counter=0;
    }
  } else {
    /* time to sum my energy into total */
    if (Genergy_counter==1) {
      Gtotal_energy+= a_->myEnergy();
      /* If I am dead (I will enter here only once) */
      if (a_->myEnergy() < MYZERO && !a_->jaSai) {
        Galive_nodes--;
        Gnode_rays[a_->Raio]--;
        if (a_->isCH()) Gwave_clus[a_->wave]--;
        a_->jaSai=true;
        
        if (a_->next.id != -2) {
          if(a_->distBase() <= wd1_) {
            printf("__W1 DEATH: %f\n",Scheduler::instance().clock());
            w1_++;
          } else if (a_->distBase() > wd1_ && a_->distBase()<= wd2_) {
            printf("__W2 DEATH: %f\n",Scheduler::instance().clock());
            w2_++;
          } else if (a_->distBase() > wd2_ && a_->distBase() <= wd3_) {
            printf("__W3 DEATH: %f\n",Scheduler::instance().clock());
            w3_++;
          } else if (a_->distBase() > wd3_) {
            printf("__W4 DEATH: %f\n",Scheduler::instance().clock());
            w4_++  ;
          }
        }
      }
    }
  }
  resched(1.0);
  #endif
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Timer responsible for sending current energy value to my CH */
void RotateTimer_::expire(Event *) {
  Packet* pkt = a_->allocpkt();
  hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);
  a_->initPkt(pkt,IP_BROADCAST);  
  hdr->type  = ENERGY_DATA;
  hdr->data1 = a_->next.id;
  hdr->data2 = a_->myEnergy();
  a_->setRFPower(INTERCP);
  a_->send(pkt,0);
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Timer responsible for sending BEACON_ROUTE at right times, in order to
 * create a backbone */
void RouteTimer_::expire(Event *) {
  if (a_->counter2 == a_->rd2) {
    Packet* pkt = a_->allocpkt();
    hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);
    a_->initPkt(pkt,IP_BROADCAST);  
    hdr->type  = BEACON_ROUTE;
    hdr->data2 = (20 - a_->rd2)*TIMER;
    hdr->data1 = (a_->wave+1);
    #ifdef DEBUG_MYUNEQ
    printf("minha wave: %d\n",a_->wave);
    printf("*-%d enviando wave %d\n",a_->me(),hdr->data1);
    #endif
    #ifdef EVALUATE_MYUNEQ
    if ((a_->wave) > Gwave_max) {
      Gwave_max=a_->wave;
    }
    Gwave_clus[a_->wave]++;
    #endif
    a_->setRFPower(INTERCP);
    a_->send(pkt,0);
  } else {
    a_->counter2++;
    resched(TIMER);
  }
}

/* ----------------------------------------------------------------------------------------------------------- */
/* Timer tha controls base-station behaviour, how it will create the routes, discover potences,
 * etc */
void SetupTimer_::expire(Event *) {
  Packet* pkt = a_->allocpkt();
  //a_->q_.push(pkt);
  hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);
  a_->initPkt(pkt,IP_BROADCAST);  

  if (a_->counter<22) {

    hdr->type  = INCR_POT;  
    hdr->data1 = a_->counter;
    a_->setRFPower(a_->counter);
    a_->send(pkt,0);

  } else if (a_->counter==22) {

    hdr->type  = SETUP_CONFIG;
    #ifdef DEBUG_MYUNEQ
    printf("RFsent: %dx%d <<< \n",RFMinG_,RFMaxG_);
    #endif
    hdr->data1 = RFMinG_;
    hdr->data2 = RFMaxG_;
    a_->send(pkt,0);

  }
  if (a_->counter<310)
    resched(TIMER);
  
  if (a_->counter++ == 305) {

    a_->setRFPower(TD_MAX);
    a_->initPkt(pkt,IP_BROADCAST);  
    hdr->type  = BEACON_ROUTE;

    hdr->data1 = 0; // no. of the wave
    hdr->data2 = 0; // time waited, for readjustment
    a_->send(pkt,0);

  }
}


/* ----------------------------------------------------------------------------------------------------------- */
#ifdef EVALUATE_MYUNEQ
void RRUCRAgent::CheckForFailures(){

  if (Gfailure && myEnergy() > MYZERO && Gfailures[wave]>0) {
    setColor("pink");
    printf("%d failed (wave %d)(Gfailures total dessa wave: %d)\n",me(),wave,Gfailures[wave]);
    Raio    = 0;
    next.id = -2;
    node->energy_model()->setenergy(0);
    Gfailures[wave]--;
    wave    = 0;
  }
}
#endif


/* ----------------------------------------------------------------------------------------------------------- */
/* Timer responsible for almost eveything in general nodes:
 * creating clusters, backbones, managing rotations, etc */
void CountTimer_::expire(Event *) {
  Tcl &tcl = Tcl::instance();
  if (!a_->allOk) {
    a_->counter++;
    if (a_->counter==COUNTER_PHASE_1) {
      a_->Op1();
    } else if (a_->counter == COUNTER_PHASE_2+a_->rd) {
      a_->RollCompeteHead();
    } else if (a_->counter==COUNTER_PHASE_3 && a_->SCH.tam<1 && a_->beTentativeHead<1) {
      a_->JoinCompetition();
    } else if (a_->counter == COUNTER_PHASE_4 +a_->rd && a_->beTentativeHead>0) {
      a_->CheckHigherEnergyToBecomePrimaryFinalHead();
    } else if (a_->counter==COUNTER_PHASE_5) {
      a_->rd=rand()%50;
    } else if (a_->counter==COUNTER_PHASE_5+a_->rd && 
              (a_->beTentativeHead<4 && (a_->SCH.tam<1 || a_->finals==0))) {
      a_->BecomeSecondaryFinalHead();
    } else if (a_->counter==COUNTER_PHASE_6) {
      a_->CheckClustersDensity();
    } else if (a_->counter==COUNTER_PHASE_7+a_->rd && a_->counter<COUNTER_PHASE_8 && a_->isCH()) {
      a_->AdvertiseCH();
    } else if (a_->counter==COUNTER_PHASE_8) {
      a_->rd=rand()%30;
    } else if (a_->counter==COUNTER_PHASE_9+a_->rd && a_->beTentativeHead<=0) {
      a_->JoinClosestCluster();
    } else if (a_->counter >= COUNTER_PHASE_10) {
      a_->EndConfig();
    }

  } else { /*allOk (clusters already ok and backbone created)*/
    #ifdef EVALUATE_MYUNEQ
    a_->CheckForFailures();
    #endif

    if (a_->beTentativeHead>0) { /* I am CH */

      if (a_->myEnergy() < pRotate*a_->higherRE.v && !a_->rotate && a_->myEnergy()>MYZERO){
        a_->AskRotation();
      } else if (a_->rotate) {
        if (a_->counter==COUNTER_PHASE_ROTATE && a_->rotate_ok) { /* aviso pro cara que tem mais energia que ele eh o novo ch */
          a_->Rotate();
        } else if (a_->counter>COUNTER_PHASE_ROTATE) {
          a_->rotate=false;
          a_->higherRE.v=dEnergy*a_->myEnergy();
        }
        a_->counter++;
      }
    }
  }
  resched(TIMER);
}

/* ----------------------------------------------------------------------------------------------------------- */


void RRUCRAgent::RRUCRrecv(Packet* pkt)
{
  hdr_cmn *cmh = HDR_CMN(pkt);
  hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);

  /* ANY NODE CAN RECEIVE A MESSAGE OF THIS TYPE */
  if (hdr->type == DATA_GATHERED) {
    HandleDATA_GATHERED(pkt,cmh,hdr);
    return;
  }

  /* MEASURES FOR NON SINK NODES */
  if (me() != BASE_STATION_.id) { 

    switch (hdr->type) {
      case INCR_POT:
        HandleINCR_POT(pkt,cmh,hdr);
        break;
      case SETUP_CONFIG:
        HandleSETUP_CONFIG(pkt,cmh,hdr);
        break;
      case COMPETE_HEAD:
        HandleCOMPETE_HEAD(pkt,cmh,hdr);
        break;
      case FINAL_HEAD:
        HandleFINAL_HEAD(pkt,cmh,hdr);
        break;
      case CH_ADV:
        HandleCH_ADV(pkt,cmh,hdr);
        break;
      case JOIN_CLUSTER:
        HandleJOIN_CLUSTER(pkt,cmh,hdr);
        break;
      case BEACON_ROUTE:
        HandleBEACON_ROUTE(pkt,cmh,hdr);
        break;
      case ROTATE_CH:
        HandleROTATE_CH(pkt,cmh,hdr);
        break;
      case ENERGY_DATA:
        HandleENERGY_DATA(pkt,cmh,hdr);
        break;
      case DENOMINATE_CH:
        HandleDENOMINATE_CH(pkt,cmh,hdr);
        break;
      case INFORM_NEW_CH:
        HandleINFORM_NEW_CH(pkt,cmh,hdr);
        break;
    }
  
  /* MEASURES FOR SINK */
  } else {

    if (hdr->type == POT_ANS) {
      HandlePOT_ANS(pkt,cmh,hdr);
      return;
    }

  }

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::GenerateData(){

  Packet* pkt = allocpkt(); /* nao deveria precisar.. FIXME */
  hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);
  int id=initPkt(pkt,IP_BROADCAST);//a_->next.id);
//cmh->ptype()=PT_RRUCR;
  #ifdef DEBUG_MYUNEQ
  printf("oooGENERATED %d\n",id);
  printf("nó %d enviando pacote %d para %d(master)\n",me(),id,next.id);
  #endif
  hdr->next = next.id;
  hdr->type = DATA_GATHERED;
  hdr->data1 = 0;
  hdr->data2 = INF;
  setRFPower(INTERCP);
  if (next.id != -1) {
    #ifdef EVALUATE_MYUNEQ
    Gsent_packets++;
    #endif
    send(pkt,0);
  }

}

/* ----------------------------------------------------------------------------------------------------------- */

void RRUCRAgent::recv(Packet* pkt, Handler*)
{
  hdr_cmn *cmh = HDR_CMN(pkt);
  hdr_ip *iph = HDR_IP(pkt);
  hdr_RRUCR* hdr = (hdr_RRUCR*) hdr_RRUCR::access(pkt);

  int src = Address::instance().get_nodeaddr(iph->saddr());
  /* This means that a application on the upper level on the network stack
     generated traffic */
  if(me() == src && cmh->ptype() != PT_RRUCR){
    GenerateData();
    return;
  }


  if (cmh->ptype() != PT_RRUCR) /* preciso lidar com outros tipos de pacotes? */
    return;
  
  if (cmh->prev_hop_ == me() && hdr->type != 0) { /* if hdr->type=0 then I musn't send anything yet */
    cmh->direction()= hdr_cmn::DOWN; /* in order to send efectively */
    send(pkt,0);
    return;
  }

  RRUCRrecv(pkt);
}

/* ----------------------------------------------------------------------------------------------------------- */

int RRUCRAgent::command(int argc, const char*const* argv) 
{
  //Tcl &tcl = Tcl::instance();
  if (argc == 2) {
     
    if (strcasecmp(argv[1], "start-RRUCR")==0) {
      setRFPower(0);

      #ifdef EVALUATE_MYUNEQ
      if (distBase() > Gfarthest_) {
        Gfarthest_ = distBase();
        wd1_ = 0.8 * Gfarthest_ / 10;
        wd2_ = 1.6 * Gfarthest_ / 10;
        wd3_ = 2.5 * Gfarthest_ / 10;
        printf("dists:%f,%f,%f\n",wd1_,wd2_,wd3_);
      }
      #endif

      return TCL_OK;
    }

    if (strcasecmp(argv[1], "cluster-color")==0) {
      colorize=true;
      if (isCH()) {
        setColor("black");
      } else {
        setColor(vColor.getColor(next.id));
      }
      return TCL_OK;
    }

    else if (strcasecmp(argv[1], "pot_setup")==0) {
      node=(MobileNode*) MobileNode::get_node_by_address(me());
      BASE_STATION_.id = me();
      BASE_STATION_.x  = node->X();
      BASE_STATION_.y  = node->Y();
      #ifdef COLORU
      setColor("purple");
      #endif
      setLabel("SINK",-1);
      mt_.sched(0.0);
      return TCL_OK;           
    }
  
    else if (strcasecmp(argv[1], "debug-on")==0) {
      #ifdef EVALUATE_MYUNEQ
      Galive_nodes++;
      #endif
      dt_.sched(0.0);
      return TCL_OK;
    }

  } else if (argc == 3) {
  
    if (strcasecmp (argv[1], "tracetarget") == 0) {
      TclObject *obj;
      if ((obj = TclObject::lookup (argv[2])) == 0) {
        fprintf (stderr, "%s: %s lookup of %s failed\n", 
                          __FILE__, argv[1], argv[2]);
        return TCL_ERROR;
      }
      tracetarget = (Trace *) obj;
      return TCL_OK;
    }
  
    else if (strcasecmp(argv[1], "port-dmux") == 0) {
      return TCL_OK;
    }
   
    else if (strcasecmp(argv[1], "addr") == 0) {
      myaddr_ = Address::instance().str2addr(argv[2]);
      return TCL_OK;
    }

  } else if (argc == 5) {
    
    if (strcasecmp(argv[1],"failure") == 0) { /* failure NUMBER a0 an */
      printf("FAILURE\n");
      #ifdef EVALUATE_MYUNEQ
      Gfailure=true;
      #endif
      int pct;
      int num = Address::instance().str2addr(argv[2]);
      int min = Address::instance().str2addr(argv[3]);
      int max = Address::instance().str2addr(argv[4]);
      for (int i=0;i<num;i++) {
        pct=rand()%(max+1-min);
        #ifdef EVALUATE_MYUNEQ
        Gfailures[min+pct]++;
        #endif
        printf("%d + %d = %d vai falhar.\n",min,pct,min+pct);
      }
      return TCL_OK;
    }
  
  }
  return Agent::command(argc, argv);
}
