remove-packet-header LRWPAN XCP PGM PGM_SPM PGM_NAK Pushback NV LDP MPLS Ping TFRC TFRC_ACK Diffusion RAP TORA IMEP MIP IPinIP Encap HttpInval SRMEXT SRM aSRM mcastCtrl CtrMcast GAF SCTP RTP IVS QS UMP AODV

source param-Grid.tcl
set val(rp) RRUCR

set ns [new Simulator]
set topo [new Topography]
$topo load_flatgrid $val(x) $val(y)
$ns trace-all [open simple.tr w]
$ns namtrace-all-wireless [open out.nam w] $val(x) $val(y)

set SINK 0
set NODET 8

proc finish {} {
				#exec nam out.nam &
				exit 0
}

create-god $val(nn)


$ns node-config -adhocRouting $val(rp) \
     -llType $val(ll) \
     -macType $val(mac) \
     -ifqType $val(ifq) \
     -ifqLen $val(ifqlen) \
     -antType $val(ant) \
     -propType $val(prop) \
     -phyType $val(netif) \
     -channelType $val(chan) \
     -topoInstance $topo \
     -agentTrace ON \
     -routerTrace ON \
     -macTrace ON \
     -movementTrace OFF \
     -energyModel EnergyModel \
     -rxPower $val(rxP) \
     -txPower $val(txP) \
     -sensePower $val(ssP) \
     -idlePower $val(idP)

## parâmetros, de acordo com o datasheet do CC1000 // creditos à Daniel Fernandes Macedo por fornecer os valores
Phy/WirelessPhy set CPThresh_ $val(CPThresh_)
Phy/WirelessPhy set CSThresh_ $val(CSThresh_)
Phy/WirelessPhy set RXThresh_ $val(RXThresh_)
Phy/WirelessPhy set freq_		  $val(freq_)
Phy/WirelessPhy set L_				$val(L_)
##Range: 177.38m
Phy/WirelessPhy set Pt_ Pf_ff
Phy/WirelessPhy set Pt_consume_ Pt_consume_ff


if { $val(randomEnergy) == 1 } {
  set energyRNG [new RNG]
  set nodeEnergy [new RandomVariable/Uniform]
  for {set i 0} {$i <= $val(numsim)} {incr i} {
   $energyRNG next-substream
  }
  $nodeEnergy set min_ $val(minEnergy)
  $nodeEnergy set max_ $val(maxEnergy)
  $nodeEnergy use-rng $energyRNG
}

for {set i 0} {$i<$val(nn)} {incr i} {
   if { $val(randomEnergy) == 1 } {
      $ns node-config -initialEnergy [$nodeEnergy value]
   } else {
      $ns node-config -initialEnergy $val(energy)
   }
	 set node_($i) [$ns node]
	 $node_($i) color black
	 $node_($i) shape circle
	 set p_($i) [new Agent/RRUCR]
	 $ns attach-agent $node_($i) $p_($i)
	 set phy_($i) [$node_($i) set netif_(0)]
	 $p_($i) addr $i
	 $node_($i) set Z_ 0.0
	 set a [expr {int(5+($i/20)*15)}]
	 set b [expr {int(5+($i%20)*20)}]
	 $node_($i) set Y_ $a
	 $node_($i) set X_ $b
	 $ns at 0.0 "$node_($i) color black"
	 $ns at 0.0 "$p_($i) debug-on"
}

set sink [new Agent/Null]
$ns attach-agent $node_($SINK) $sink

for {set i 1} {$i<$val(nn)} {incr i} {
	set udp_($i) [new Agent/UDP]
	$ns attach-agent $node_($i) $udp_($i)

	set exp_($i) [new Application/Traffic/Exponential]
	$exp_($i) set rate_ 0.00000030517578125Mb; # taxa de 0.1% de chance de mandar 32 bytes no segundo
	$exp_($i) set packetSize_ 32 ;
	$exp_($i) set maxpkts_ 10
	$exp_($i) attach-agent $udp_($i)

	$ns attach-agent $node_($i) $exp_($i)
	$ns connect $udp_($i) $sink
	$ns at 500.0 "$exp_($i) start"

	$ns initial_node_pos $node_($i) $NODET
	$ns at 100.0 "$p_($i) cluster-color"
}


$ns at 0.05 "$p_($SINK) pot_setup"

#
$ns at $val(timesim) "$ns nam-end-wireless $val(timesim)"
$ns at $val(timesim) "finish"
$ns run
