library ieee;
use ieee.std_logic_1164.all;

entity reg is
port( clock, rst: in std_logic;
       	D: in  std_logic_vector(31 downto 0);
       	Q: out std_logic_vector(31 downto 0)
    );
end reg;

architecture arq_reg of reg is 
begin
    process(clock, rst)
    begin
        if (rst = '1') then
            Q <= (others => '0');
        elsif (clock'event and clock = '1') then
            Q <= D; 
        end if;
    end process;
end arq_reg;
