-- Programa principal

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity media is
port ( in_1: in integer;
        en: in std_logic;
        enable2: in std_logic;
		clk: in std_logic;
		out_1: out std_logic_vector(31 downto 0)
		);
end media;

architecture arq_m of media is
	component acumulador is
    port (entrada: in integer;
            en: in std_logic;
            enable2: in std_logic;
		    clk: in std_logic;
		    soma: out std_logic_vector(31 downto 0);
		    contador: out integer;
		    enSaida: out std_logic
	    );
	end component;
	component div is
	port (I2: in std_logic_vector(31 downto 0);
			I3: in integer;
			enable: in std_logic;
			clk: in std_logic;
			O2: out std_logic_vector(31 downto 0)
		);
	end component;
	signal f1: std_logic_vector(31 downto 0);
	signal f2: integer;
	signal enab: std_logic;
begin
	acumula: acumulador port map (entrada => in_1, en => en, enable2 => enable2, clk => clk, soma => f1, contador => f2, enSaida => enab);
	divide: div port map (I2 => f1, I3 => f2, enable => enab, clk => clk, O2 => out_1);
end arq_m;
