-- Realiza a divisao e a multiplicacao

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity div is
port ( I2: in std_logic_vector(31 downto 0);
		I3: in integer;
		enable: in std_logic;
		clk: in std_logic;
		O2: out std_logic_vector(31 downto 0)
	);
end div;

architecture arq_div of div is
	component componente_inicial is
	port (E1: in integer;
	        enable: in std_logic;
			Clock: in std_logic;
			S1: out std_logic_vector(31 downto 0)
			);
	end component;
	component componente_divide is
	port (E2: in std_logic_vector(31 downto 0);
			E3: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S2: out std_logic_vector(24 downto 0)
			);
	end component;
	component componente_operaexp is
	port (E4: in std_logic_vector(31 downto 0);
			E5: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S3: out std_logic_vector(7 downto 0)  -- retorna o expoente
			);
	end component;
	component componente_normdiv is
	port (E6: in std_logic_vector(24 downto 0);  -- resultado de divide
			E7: in std_logic_vector(7 downto 0);  -- resultado de operaexp
			E8: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			E9: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			Clock: in std_logic;
			S4: out std_logic_vector(31 downto 0) 
			);
	end component;
	component componente_multmant is
	port (E10: in std_logic_vector(31 downto 0);
			E11: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S5: out std_logic_vector(47 downto 0)
			);
	end component;
	component componente_somaexp is
	port (E12: in std_logic_vector(31 downto 0);
			E13: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S6: out std_logic_vector(7 downto 0)  -- retorna o expoente
			);
	end component;
	component componente_normres is
	port (E14: in std_logic_vector(47 downto 0);  -- resultado de multmant
			E15: in std_logic_vector(7 downto 0);  -- resultado de somaexp
			E16: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			E17: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			Clock: in std_logic;
			S7: out std_logic_vector(31 downto 0)  -- 1 (sinal) + 8 (expoente) + 23 (mantissa) 
			);
	end component;
	component componente_regv is
	port (Ev: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			Sv: out std_logic_vector(31 downto 0)
			);
	end component;
	signal f1: std_logic_vector(31 downto 0);
	signal f2: std_logic_vector(31 downto 0);
	signal f3: std_logic_vector(24 downto 0); 
	signal f4: std_logic_vector(7 downto 0);
	signal f5: std_logic_vector(31 downto 0);
	signal f7: std_logic_vector(47 downto 0);
	signal f8: std_logic_vector(7 downto 0);
	signal um: std_logic_vector(31 downto 0) := "00111111100000000000000000000000";
begin
	inicial1: componente_inicial port map(E1 => I3, enable => enable, Clock => clk, S1 => f2);
	divmant1: componente_divide port map(E2 => um, E3 => f2, Clock => clk, S2 => f3);
	subtexp1: componente_operaexp port map(E4 => um, E5 => f2, Clock => clk, S3 => f4);
	normdiv1: componente_normdiv port map(E6 => f3, E7 => f4, E8 => um, E9 => f2, Clock => clk, S4 => f5);
	reg2: componente_regv port map(Ev => I2, Clock => clk, Sv => f1);
	multmant1: componente_multmant port map(E10 => f1, E11 => f5, Clock => clk, S5 => f7);
	somaexp1: componente_somaexp port map(E12 => f1, E13 => f5, Clock => clk, S6 => f8);
	normres1: componente_normres port map(E14 => f7, E15 => f8, E16 => f1, E17 => f5, Clock => clk, S7 => O2);
end arq_div;
