-- Realiza a soma dos expoentes e informa o valor que o expoente tera'

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_somaexp is
port (E12: in std_logic_vector(31 downto 0);
		E13: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S6: out std_logic_vector(7 downto 0)  -- retorna o expoente
		);
end componente_somaexp;
		
architecture a_soma of componente_somaexp is
  signal tmp: std_logic_vector(7 downto 0);
begin
	-- Etapa 3
	process(E13)
		variable SinalA, SinalB: std_logic;
		variable ExpA, ExpB, CentoEVinteESete: std_logic_vector(7 downto 0);
		variable MantA, MantB: std_logic_vector(22 downto 0);
		variable subtrai: integer;
		variable Subt1, Subt2, SubtFinal: std_logic_vector(7 downto 0);
		variable ValorInt, ValorInt2, ValorInt3: integer;
	begin
		tmp <= "00000000";
		-- Se os 2 foram zero, nem precisa fazer a multiplicacao
		if (not(E12 = "00000000000000000000000000000000" and E13 = "00000000000000000000000000000000")) then
			-- Separa dados de A
			SinalA := E12(31);
			ExpA(7 downto 0) := E12(30 downto 23);
			MantA(22 downto 0) := E12(22 downto 0);
			-- Separa dados de B
			SinalB := E13(31);
			ExpB(7 downto 0) := E13(30 downto 23);
			MantB(22 downto 0) := E13(22 downto 0);
			--
			CentoEVinteESete := "01111111";
			-- Subtracoes
			--		   10000100         01111111
			--		 - 01111111       - 00111100
	 				  ----------       ----------
			--		   00000101         01000011
			--	    exp verdadeiro   exp verdadeiro
			--		     e' 5.           e' -67
			Subt1 := ExpA - CentoEVinteESete;
			Subt2 := CentoEVinteESete - ExpB;
			ValorInt := to_integer(signed(Subt2)) * (-1);
			-- Soma expoentes verdadeiros      5 + (+67) e' 72.
			ValorInt2 := to_integer(signed(Subt1)) + ValorInt;
			-- Soma 127 ao valor anteriormente encontrado
			ValorInt3 := ValorInt2 + 127;  -- 72 + 127 = 199 
			-- Resultado
			tmp <= std_logic_vector(to_signed(ValorInt3, 8)); -- "11000111"
		end if;
	end process;
    -- Resultado
    S6 <= tmp;
end a_soma;
