-- Ira normalizar o resultado, que tera 32 bits e estara no formato ponto flutuante padrao 754
-- O valor resultante neste componente e' enviado para um multiplexador que ira decidir se usa este
-- valor para acumular as demais entradas que forem propostas

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity componente_soma4 is
port (  SaidaSoma: in std_logic_vector(33 downto 0);
	    Clk: in std_logic;
	    O_fim1: out std_logic_vector(31 downto 0)
    );
end componente_soma4;

architecture a_soma4 of componente_soma4 is
  signal tmp: std_logic_vector(31 downto 0);
begin
	process(SaidaSoma)
		variable ExpNormFim: std_logic_vector(7 downto 0) := "00000000";
		variable escolhe: std_logic_vector(31 downto 0) := "00000000000000000000000000000000";
		variable SinalNormFim: std_logic := '0';
		variable MantNormFim: std_logic_vector(24 downto 0) := "0000000000000000000000000";
		variable tmpNormFim: std_logic_vector(9 downto 0) := "0000000000";
	begin
		-- Separa dados da soma
		SinalNormFim := SaidaSoma(33);
		ExpNormFim(7 downto 0) := SaidaSoma(32 downto 25);
		MantNormFim(24 downto 0) := SaidaSoma(24 downto 0);
		-- Deixa resultado normalizado de acordo com valores da mantissa
		if (MantNormFim(23) = '0' and not(MantNormFim(24) = '1')) then
			while (MantNormFim(23) = '0' and not(MantNormFim(22 downto 0) = "00000000000000000000000") ) loop
				ExpNormFim := ExpNormFim - "00000001";
				MantNormFim(23 downto 1) := MantNormFim(22 downto 0);
				MantNormFim(0) := '0';
			end loop;
			tmpNormFim := "0000000000";
			tmpNormFim := '0' & SinalNormFim & ExpNormFim;
			tmp <= tmpNormFim(8 downto 0) & MantNormFim(22 downto 0);
		elsif(MantNormFim(24) = '1' and MantNormFim(23) = '1') then
			tmpNormFim := SinalNormFim & ExpNormFim & '1';
			tmp <= tmpNormFim(9 downto 0) & MantNormFim(22 downto 1);
		elsif(MantNormFim(24) = '1' and MantNormFim(23) = '0') then
			tmpNormFim := SinalNormFim & ExpNormFim & '0';
			tmp <= tmpNormFim(9 downto 0) & MantNormFim(22 downto 1);	
		else
			tmpNormFim := "0000000000";
			tmpNormFim := '0' & SinalNormFim & ExpNormFim;
			tmp <= tmpNormFim(8 downto 0) & MantNormFim(22 downto 0);
		end if;
    end process;
    O_fim1 <= tmp; -- somatorio/acumulador
end a_soma4;
