-- Os dois valores que anteriormente foram deslocados, agora serao somados

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity componente_soma3 is
port (  I3: in std_logic_vector(32 downto 0);
        I4: in std_logic_vector(32 downto 0);
	    Clk: in std_logic;
	    SaidaSoma: out std_logic_vector(33 downto 0)
    );
end componente_soma3;

architecture a_soma3 of componente_soma3 is
begin
	process(I3, I4)
		variable ExpSomaA, ExpSomaB, ExpSoma: std_logic_vector(7 downto 0) := "00000000";
		variable SinalSomaA, SinalSomaB, SinalSoma: std_logic := '0';
		variable MantSomaA, MantSomaB: std_logic_vector(23 downto 0) := "000000000000000000000000";
		variable SomaMants: std_logic_vector(24 downto 0) := "0000000000000000000000000";
	begin
		-- Separa dados de A
		SinalSomaA := I3(32);
		ExpSomaA(7 downto 0) := I3(31 downto 24);
		MantSomaA(23 downto 0) := I3(23 downto 0);
		-- Separa dados de B
		SinalSomaB := I4(32);
		ExpSomaB(7 downto 0) := I4(31 downto 24);
		MantSomaB(23 downto 0) := I4(23 downto 0);
		-- Regra de sinal
		if SinalSomaA = SinalSomaB then
			SinalSoma := '0'; -- POSITIVO
		else
			SinalSoma := '1'; -- NEGATIVO
		end if;
		-- Calcula Expoente
		ExpSoma(7 downto 0) := ExpSomaA(7 downto 0);
		-- Calcula mantissa (Soma)
		SomaMants := ('0' & MantSomaA) + ('0' & MantSomaB);
		-- Verifica se os dois operandos sao 0
		if (ExpSomaA(7 downto 0) = "00000000" and ExpSomaB(7 downto 0) = "00000000" and MantSomaA(22 downto 0) = "00000000000000000000000" and MantSomaB(22 downto 0) = "00000000000000000000000") then
			SaidaSoma <= SinalSoma & ExpSoma & SomaMants(24 downto 0);
		-- Verifica a necessidade de incrementar o expoente (incrementa se houve bit de carry)	
		elsif (SomaMants(24) = '1') then
			ExpSoma(7 downto 0) := ExpSoma(7 downto 0) + "00000001";
		end if;
		
		-- Resultado, caso os dois operandos nao sejam zero
		if (not(ExpSomaA(7 downto 0) = "00000000" and ExpSomaB(7 downto 0) = "00000000" and MantSomaA(22 downto 0) = "00000000000000000000000" and MantSomaB(22 downto 0) = "00000000000000000000000")) then  -- se entrou no if anterior e ja' estabeleu valor para Saida, nao sobrescreve aqui
			SaidaSoma <= SinalSoma & ExpSoma & SomaMants(24 downto 0);
		end if;
	end process;
end a_soma3;
