-- Recebe o valor para ser acumulado e o valor que ja esta acumulado e os desloca, de forma a ser
-- possivel a soma destes valores atraves do algoritmo utilizado 

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

-- Uma entrada e' o valor da soma acumulada (I2_1) e a outra e' o novo valor a ser somado (I2)
entity componente_soma2 is
port (I2: in std_logic_vector(31 downto 0);
		I2_1: in std_logic_vector(31 downto 0);
		Cont: in integer;
		Clk: in std_logic;
		SaidaShiftA: out std_logic_vector(32 downto 0);
		SaidaShiftB: out std_logic_vector(32 downto 0)
		);
end componente_soma2;

architecture a_soma2 of componente_soma2 is
begin
	process(Cont, I2)
		variable ExpShiftA, ExpShiftB, ExpSomaA, ExpSomaB: std_logic_vector(7 downto 0) := "00000000";
		variable SinalShiftA, SinalShiftB: std_logic := '0';
		variable MantShiftA, MantShiftB: std_logic_vector(23 downto 0) := "000000000000000000000000";
		variable tmpShift: std_logic_vector(8 downto 0) := "000000000";
		variable operador: std_logic_vector(31 downto 0);
		variable cnt: integer;
	begin
		-- Separa dados de A
		SinalShiftA := I2_1(31);
		ExpShiftA(7 downto 0) := I2_1(30 downto 23);
		MantShiftA(22 downto 0) := I2_1(22 downto 0);
		MantShiftA(23) := '1';
		-- Separa dados de B
		SinalShiftB := I2(31);
		ExpShiftB(7 downto 0) := I2(30 downto 23);
		MantShiftB(22 downto 0) := I2(22 downto 0);
		MantShiftB(23) := '1';
		--
		-- Modifica valor do expoente e da mantissa, caso haja necessidade (para que o valor do
		-- expoente dos 2 operandos seja igual)
        --		Ex.:
        --		0 01111101 00000000000000000000000 (original value)
        --		0 01111110 10000000000000000000000 (shifted 1 place)
        --		0 01111111 01000000000000000000000 (shifted 2 places)
		--
		cnt := 0;
		if (to_integer(unsigned(ExpShiftA)) < to_integer(unsigned(ExpShiftB))) then
			while (cnt < 257 and to_integer(unsigned(ExpShiftA)) < to_integer(unsigned(ExpShiftB))) loop
				cnt := cnt + 1;
				ExpShiftA := ExpShiftA + "00000001";
				MantShiftA(22 downto 0) := MantShiftA(23 downto 1);
				MantShiftA(23) := '0';
			end loop;
		--
		elsif (to_integer(unsigned(ExpShiftA)) > to_integer(unsigned(ExpShiftB))) then
			while (cnt < 257 and to_integer(unsigned(ExpShiftA)) > to_integer(unsigned(ExpShiftB))) loop
				cnt := cnt + 1;
				ExpShiftB := ExpShiftB + "00000001";
				MantShiftB(22 downto 0) := MantShiftB(23 downto 1);
				MantShiftB(23) := '0';
			end loop;
 		-- E se os valores dos expoentes jah forem iguais, faz nada
		end if;
		tmpShift := SinalShiftA & ExpShiftA;
		SaidaShiftA <= tmpShift & MantShiftA;
		tmpShift := SinalShiftB & ExpShiftB;
		SaidaShiftB <= tmpShift & MantShiftB;
	end process;
end a_soma2;
