-- Faz subtracao dos expoentes e informa o valor que o expoente da operacao de divisao tera'

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_operaexp is
port (E4: in std_logic_vector(31 downto 0);
		E5: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S3: out std_logic_vector(7 downto 0)  -- retorna o expoente
		);
end componente_operaexp;
		
architecture a_operaexp of componente_operaexp is
  signal tmp: std_logic_vector(7 downto 0);
begin
	process(E5)
		variable SinalA, SinalB: std_logic;
		variable ExpA, ExpB, CentoEVinteESete: std_logic_vector(7 downto 0);
		variable MantA, MantB: std_logic_vector(22 downto 0);
		variable subtrai: integer;
		variable Subt1, Subt2, SubtFinal: std_logic_vector(7 downto 0);
		variable ValorInt, ValorInt2, ValorInt3: integer;
	begin
		tmp <= "00000000";
		-- Separa dados de A
		SinalA := E4(31);
		ExpA(7 downto 0) := E4(30 downto 23);
		MantA(22 downto 0) := E4(22 downto 0);
		-- Separa dados de B
		SinalB := E5(31);
		ExpB(7 downto 0) := E5(30 downto 23);
		MantB(22 downto 0) := E5(22 downto 0);
		--
		CentoEVinteESete := "01111111";
		-- Subtracoes
		--		   10000100         01111111  
		--		 - 01111111       - 00111100   
 				  ----------       ----------
		--		   00000101         01000011
		--	    exp verdadeiro   exp verdadeiro
		--		     e' 5.           e' -67
		Subt1 := ExpA - CentoEVinteESete;
		Subt2 := CentoEVinteESete - ExpB;
		ValorInt := to_integer(signed(Subt2)) * (-1); -- (67 * (-1) = +67)
		-- Subtrai expoentes verdadeiros (5 - (+67) e' -62)
		ValorInt2 := to_integer(signed(Subt1)) - ValorInt;
		-- Soma 127 ao valor anteriormente encontrado
		ValorInt3 := ValorInt2 + 127;  -- (-62 + 127 = 65) 		
		tmp <= std_logic_vector(to_signed(ValorInt3, 8)); -- "00100001"
	end process;
    -- Resultado
	S3 <= tmp;
end a_operaexp;
