-- Normaliza resultado da multiplicacao e consequentemente o resultado final do calculo da media aritmetica

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_normres is
port (E14: in std_logic_vector(47 downto 0);  -- resultado de multmant
		E15: in std_logic_vector(7 downto 0);  -- resultado de somaexp
		E16: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
		E17: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
		Clock: in std_logic;
		S7: out std_logic_vector(31 downto 0)  -- 1 (sinal) + 8 (expoente) + 23 (mantissa)  
		);
end componente_normres;
		
architecture a_normres of componente_normres is
  signal tmp: std_logic_vector(31 downto 0);
begin
	-- Etapa 4
	process(E14, E15)
		variable SinalA, SinalB: std_logic; 
		variable Mant: std_logic_vector(46 downto 0);
		variable Exp: std_logic_vector(7 downto 0); 
		variable Sinal: std_logic; 
	begin
        if (E16 = "00000000000000000000000000000000") then -- Se a soma e' 0, entao o resultado e' 0
            tmp <= "00000000000000000000000000000000";
	    elsif (E16(31 downto 0) = E17(31 downto 0)) then -- Se o valor de soma e o valor dado pela divisao sao iguais, entao o resultado e' 1
		    tmp <= "00111111100000000000000000000000"; 
      	elsif (E17 = "00000000000000000000000000000000") then -- Se o resultado da divisao acontecer de ser 0, o resultado sera infinito
		    tmp <= "01111111100000000000000000000000";
	    elsif (E16 = "00111111100000000000000000000000" or E17 = "00111111100000000000000000000000") then  -- se algum deles e' 1, vai ser o valor do outro
		    if (E16 = "00111111100000000000000000000000") then
			    tmp <= E17;
		    else
			    tmp <= E16;
		    end if;
	    else
		    if (E14(47) = '1') then
			    -- desloca mantissa um bit a direita
			    --		     1 01000001  10.00110000
			    --	                     vvvvvvvvvvv -> Mant
			    --		     1 01000010  1.000110000
			    Mant(46 downto 0) := E14(46 downto 0);
			    -- Soma 1 ao expoente
			    --		     1 01000001  10.00110000
			    --	           vvvvvvvv       
			    --		     1 01000010  1.000110000
			    -- Obter valor dos sinais
			    Exp(7 downto 0) := E15(7 downto 0) + "00000001";
		    else  -- E14(47) = '0'
			    Mant(46 downto 1) := E14(45 downto 0);
			    Mant(0) := '0';
			    Exp(7 downto 0) := E15(7 downto 0);
		    end if;
			SinalA := E16(31);
			SinalB := E17(31);
			-- Regra de sinal 		
			if SinalA = SinalB then
				Sinal := '0'; -- POSITIVO
			else
				Sinal := '1'; -- NEGATIVO
			end if;
			-- Gera resultado final
			tmp <= Sinal & Exp(7 downto 0) & Mant(46 downto 24);
		end if;
	end process;
    -- Resultado
	S7 <= tmp;
end a_normres;
