-- Normaliza o resultado da divisao

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_normdiv is
port (E6: in std_logic_vector(24 downto 0);  -- resultado de divide
		E7: in std_logic_vector(7 downto 0);  -- resultado de operaexp
		E8: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
		E9: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
		Clock: in std_logic;
		S4: out std_logic_vector(31 downto 0) 
	);
end componente_normdiv;
		
architecture a_normdiv of componente_normdiv is
  signal tmp: std_logic_vector(31 downto 0);
begin
	process(E6, E7, E8, E9)
		variable SinalA, SinalB: std_logic; 
		variable Mant: std_logic_vector(24 downto 0);
		variable Exp: std_logic_vector(7 downto 0); 
		variable Sinal: std_logic; 
	begin
			Mant(24 downto 0) := E6(24 downto 0);
			Exp(7 downto 0) := E7(7 downto 0);
			-- Define valor de mantissa e expoente
			-- Ate que Mant(24) seja 1 ou nao tenha como haver 1 na mantissa
			while (Mant(24) = '0' and not(Mant(24 downto 0) = "0000000000000000000000000") ) loop
				Mant(24 downto 1) := Mant(23 downto 0);
				Mant(0) := '0';
				Exp(7 downto 0) := Exp(7 downto 0) - "00000001";
			end loop;
			-- Define valor de sinal
			SinalA := E8(31);
			SinalB := E9(31);
			-- Regra de sinal 		
			if SinalA = SinalB then
				Sinal := '0'; -- POSITIVO
			else
				Sinal := '1'; -- NEGATIVO
			end if;
			-- Gera resultado final
			tmp <= Sinal & Exp(7 downto 0) & Mant(23 downto 1);
	end process;
    -- Resultado
	S4 <= tmp;
end a_normdiv;
