-- Faz a multiplicacao das mantissas

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_multmant is
port (E10: in std_logic_vector(31 downto 0);
		E11: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S5: out std_logic_vector(47 downto 0)
		);
end componente_multmant;
		
architecture a_multmant of componente_multmant is
  signal tmp: std_logic_vector(47 downto 0);
begin
	-- Etapa 2
	process(Clock, E11)
		variable SinalA, SinalB: std_logic;
		variable ExpA, ExpB: std_logic_vector(7 downto 0);
		variable MantA, MantB: std_logic_vector(23 downto 0);  -- 22 + 1 (hidden bit)
	begin
		-- Inicializa resultado com zero
		tmp <= "000000000000000000000000000000000000000000000000";
		-- Se algum deles for zero, nao precisa fazer multiplicacao
		if (not(E10 = "00000000000000000000000000000000" or E11 = "00000000000000000000000000000000")) then
			-- Separa dados de A
			SinalA := E10(31);
			ExpA(7 downto 0) := E10(30 downto 23);
			MantA(22 downto 0) := E10(22 downto 0);
			MantA(23) := '1';
			-- Separa dados de B
			SinalB := E11(31);
			ExpB(7 downto 0) := E11(30 downto 23);
			MantB(22 downto 0) := E11(22 downto 0);
			MantB(23) := '1';
			-- Multiplica
			tmp <= MantA * MantB;
		end if;
	end process;
    -- Resultado
	S5 <= tmp;
end a_multmant;	
