-- Transforma um numero inteiro em um numero em ponto flutuante de 32 bits 

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
--use ieee.std_logic_arith.all; 
use ieee.numeric_std.all;
use std.textio.all; 

entity componente_inicial is
port (E1: in integer;
        enable: in std_logic;
		Clock: in std_logic;
		S1: out std_logic_vector(31 downto 0)
		);
end componente_inicial;
		
architecture a_inicial of componente_inicial is
	signal S_tmp: std_logic_vector(31 downto 0);
begin
	-- Etapa 1
	process(enable)
		variable Valor: std_logic_vector(31 downto 0);
		variable MantV: std_logic_vector(22 downto 0);
		variable ExpV: std_logic_vector(7 downto 0);
		variable Tmp: std_logic := '0';
		variable campos, i, ind: integer;
		variable mantissa, valorExpoente: integer;
	begin
		-- Determina quantos bits ocupa na mantissa
		if (enable /= enable'last_value) then
		case E1 is
			when 0 to 1 =>
				campos := 1;
				mantissa := 0;
			when 2 to 3 =>
				campos := 2;
				mantissa := 1;
			when 4 to 7 =>
				campos := 3;
				mantissa := 2;
			when 8 to 15 =>
				campos := 4;
				mantissa := 3;
			when 16 to 31 =>
				campos := 5;
				mantissa := 4;
			when 32 to 63 =>
				campos := 6;
				mantissa := 5;
			when 64 to 127 =>
				campos := 7;
				mantissa := 6;
			when 128 to 255 =>
				campos := 8;
				mantissa := 7;
			when 256 to 511 =>
				campos := 9;
				mantissa := 8;
			when 512 to 1023 =>
				campos := 10;
				mantissa := 9;
			when 1024 to 2047 =>
				campos := 11;
				mantissa := 10;
			when 2048 to 4095 =>
				campos := 12;
				mantissa := 11;
			when 4096 to 8191 =>
				campos := 13;
				mantissa := 12;
			when 8192 to 16383 =>
				campos := 14;
				mantissa := 13;
			when 16384 to 32767 =>
				campos := 15;
				mantissa := 14;
			when 32768 to 65535 =>
				campos := 16;
				mantissa := 15;
			when 65536 to 131071 =>
				campos := 17;
				mantissa := 16;
			when 131072 to 262143 =>
				campos := 18;
				mantissa := 17;
			when 262144 to 524287 =>
				campos := 19;
				mantissa := 18;
			when 524288 to 1048575 =>
				campos := 20;
				mantissa := 19;
			when 1048576 to 2097151 =>
				campos := 21;
				mantissa := 20;
			when 2097152 to 4194303 =>
				campos := 22;
				mantissa := 21;
			when 4194304 to 8388607 =>
				campos := 23;
				mantissa := 22;
			when 8388608 to 16777215 =>
				campos := 24;
				mantissa := 23;	
			when others =>
				campos := 24;
				mantissa := 23;
		end case;
		-- Converte numero inteiro para std_logic_vector
		Valor := std_logic_vector(to_unsigned(E1, 32));
		if (Mantissa > 0) then
			MantV(22 downto 0) := "00000000000000000000000";
			MantV(22 downto (23 - mantissa)) := Valor((mantissa-1) downto 0);
			valorExpoente := 127 + mantissa;
			ExpV := std_logic_vector(to_unsigned(valorExpoente, 8));
			S_tmp <= '0' & ExpV & MantV;				
		else -- (mantissa = 0) then
			if (E1 = 0) then
				MantV(22 downto 0) := "00000000000000000000000";
				ExpV(7 downto 0) := "00000000";
				S_tmp <= '0' & ExpV & MantV;
			elsif (E1 = 1) then
				MantV(22 downto 0) := "00000000000000000000000";
				ExpV(7 downto 0) := "01111111";
				S_tmp <= '0' & ExpV & MantV;		
			end if;
		end if;
		end if;
	end process;
	-- Resultado
	S1 <= S_tmp;
end a_inicial;
