-- Faz a divisao das mantissas

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_divide is
port (E2: in std_logic_vector(31 downto 0);
		E3: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S2: out std_logic_vector(24 downto 0)
		);
end componente_divide;
		
architecture a_divide of componente_divide is
  signal tmp: std_logic_vector(24 downto 0);
begin
	process(E3)
		variable SinalA, SinalB: std_logic;
		variable ExpA, ExpB: std_logic_vector(7 downto 0);
		variable MantA, MantB: std_logic_vector(24 downto 0); 
		variable Res_std: std_logic_vector(24 downto 0);
		variable limite, cont, ja_foi_um_zero, Res: integer;
	begin
		-- Inicializa resultado com zero
		tmp <= "0000000000000000000000000";
		-- Separa dados de A
		SinalA := E2(31);
		ExpA(7 downto 0) := E2(30 downto 23);
		MantA(22 downto 0) := E2(22 downto 0);
		MantA(23) := '1';
		MantA(24) := '0';
		-- Separa dados de B
		SinalB := E3(31);
		ExpB(7 downto 0) := E3(30 downto 23);
		MantB(22 downto 0) := E3(22 downto 0);
		MantB(23) := '1';
		MantB(24) := '0';
		-- Divide
		cont := 24;
		limite := 24;
		ja_foi_um_zero := 0;
		Res := 1;
		while (not(Res = 0) and (limite > 0)) loop
			Res := to_integer(unsigned(MantA)) - to_integer(unsigned(MantB));
			Res_std := MantA - MantB;
			if (Res < 0) then -- nao consegue dividir (o valor de MantB eh maior que o de MantA)
				MantA(24 downto 1) := MantA(23 downto 0);
				MantA(0) := '0';				
				if (ja_foi_um_zero = 0) then
					tmp(cont) <= '0';
					cont := cont - 1;
					ja_foi_um_zero := 1;
				end if;
			else
				ja_foi_um_zero := 0;
				tmp(cont) <= '1';
				cont := cont - 1;
				while (not(Res_std(23) = '1') and (to_integer(unsigned(Res_std)) > 0)) loop
					Res_std(24 downto 1) := Res_std(23 downto 0);
					Res_std(0) := '0';
				end loop;
				MantA(24 downto 0) := Res_std(24 downto 0);
			end if;
			limite := limite - 1;
		end loop;
	end process;
    -- Resultado
	S2 <= tmp;
end a_divide;	
