-- Realiza a soma dos valores de entrada

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity acumulador is
port (entrada: in integer;
        en: in std_logic;
        enable2: in std_logic;
		clk: in std_logic;
		soma: out std_logic_vector(31 downto 0);
		contador: out integer;
		enSaida: out std_logic
	);
end acumulador;

architecture arq_acc of acumulador is
	component componente_soma1 is
port (  I1: in integer;
        en: in std_logic;
		Clk: in std_logic;
		O1: out std_logic_vector(31 downto 0);
		contador: out integer;
		en2: out std_logic
	);
	end component;
	component componente_soma2 is
	port (I2: in std_logic_vector(31 downto 0);
			I2_1: in std_logic_vector(31 downto 0);
			Cont: in integer;
			Clk: in std_logic;
			SaidaShiftA: out std_logic_vector(32 downto 0);
			SaidaShiftB: out std_logic_vector(32 downto 0)
		);
	end component;
	component componente_soma3 is
	port (I3: in std_logic_vector(32 downto 0);
			I4: in std_logic_vector(32 downto 0);
			Clk: in std_logic;
			SaidaSoma: out std_logic_vector(33 downto 0)
		);
	end component;
	component componente_soma4 is
	port (SaidaSoma: in std_logic_vector(33 downto 0);
			Clk: in std_logic;
			O_fim1: out std_logic_vector(31 downto 0)
		);
	end component;
	component reg is
    port (clock, rst: in std_logic;
           	D: in std_logic_vector(31 downto 0);
           	Q: out std_logic_vector(31 downto 0)
        );
    end component;
    component reg_int is
	port (clock, rst: in std_logic;
           	D: in integer;
           	Q: out integer
        );
    end component;
    component reg_umbit is
	port(clock, rst : in std_logic;
           	D : in  std_logic;
           	Q : out std_logic
        );
    end component;
    component multiplexador is
	port (Seletor: in std_logic;
	        In1: in std_logic_vector(31 downto 0);
	        In2: in std_logic_vector(31 downto 0);
	        Out1: out std_logic_vector(31 downto 0)
        );
    end component;
	signal f1: std_logic_vector(31 downto 0) := "00000000000000000000000000000000";
	signal f2: std_logic_vector(31 downto 0);
	signal f3: std_logic_vector(32 downto 0); 
	signal f4: std_logic_vector(32 downto 0);
	signal f5: std_logic_vector(33 downto 0);
	signal f6: std_logic_vector(31 downto 0);
	signal f7: std_logic_vector(31 downto 0);
	signal f8: std_logic_vector(31 downto 0);	
	signal zero: std_logic := '0';
	signal stmp1: std_logic_vector(31 downto 0);
	signal stmp2: std_logic_vector(31 downto 0);
	signal stmp3: integer;
	signal soma_retro: std_logic_vector(31 downto 0);
	signal tmp_cont: integer;
	signal en_1: std_logic;
	signal en_2: std_logic;
begin
	norm: componente_soma1 port map(I1 => entrada, en => en, Clk => clk, O1 => f2, contador => tmp_cont, en2 => en_1);
	mult: multiplexador port map(Seletor => enable2, In1 => f1, In2 => soma_retro, Out1 => f8);
	reg1: reg port map(clock => clk, rst => zero, D => f2, Q => stmp1); -- Pega o novo valor
	reg2: reg port map(clock => clk, rst => zero, D => f8, Q => stmp2); -- Pega o valor do somatorio
	reg3: reg_int port map(clock => clk, rst => zero, D => tmp_cont, Q => stmp3); -- Pega o valor do contador
	reg4: reg_umbit port map(clock => clk, rst => zero, D => en_1, Q => en_2);
	shift: componente_soma2 port map(I2 => stmp1, I2_1 => stmp2, Cont => stmp3, Clk => clk, SaidaShiftA => f3, SaidaShiftB => f4);
	soma_1: componente_soma3 port map(I3 => f3, I4 => f4, Clk => clk, SaidaSoma => f5);
	norm_fim: componente_soma4 port map(SaidaSoma => f5, Clk => clk, O_fim1 => soma_retro);
    -- Resultados
	soma <= soma_retro;
	contador <= stmp3;
	enSaida <= en_2;
end arq_acc;
