-- Programa principal
-- Estah com 4 eventos de clock atrasados

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;
use work.txt_util.all;

entity tb_media is
end tb_media;

architecture t_arq_m of tb_media is
	component media is
    port ( in_1: in integer;
                enable: in std_logic;
                enable2: in std_logic;
			    clk: in std_logic;
			    rst: in std_logic;
			    out_1: out std_logic_vector(31 downto 0)	
        );
	end component;
	signal in_1                 : integer := 995;
	signal enable               : std_logic := '1';
	signal enable2              : std_logic := '0';
	signal Clk                  : std_logic := '1';
	signal rst                  : std_logic := '0';
	signal vaiResetar           : std_logic := '0';
	signal resetando            : std_logic := '0';
	signal out_1                : std_logic_vector(31 downto 0);
	signal string_valor         : string(1 to 200);
	signal cont                 : std_logic := '0';
	signal eventoContador2      : std_logic := '1';
	signal contadorControle     : integer := -1;
	signal somaDosValores       : integer := 0;
	-- 'limite' determina qual o valor maximo a ser alcancado pela soma para que tudo seja resetado
	constant limite             : integer := 20000; -- deve ser menor que 16777215
	constant PERIODO            : time := 2500 ns;
	file ARQ                    : TEXT open READ_MODE is "entrada/entrada_binaria/mitdb.txt";
	file ARQ2                   : TEXT open WRITE_MODE is "saida.txt";
	signal resInteiro           : integer;
	signal quantosClocks        : integer := 0;
begin
	md: media port map(in_1, enable, enable2, clk, rst, out_1);
----------------------------------------------------------------------------------------------------
    p1: process (clk)
        variable vezes: integer;
    begin
        if not(endfile(ARQ)) then -- enquanto nao eh o fim do arquivo de entrada
            clk <= not(clk) after PERIODO;
            if (clk = '1') then
                quantosClocks <= quantosClocks + 1;
            end if;
            vezes := 5;
        end if;
        if (endfile(ARQ) and vezes > 0) then -- para dar tempo de computar o resultado depois que o 
                                             -- arquivo de entrada chegou ao fim
            clk <= not(clk) after PERIODO;
            if (clk = '1') then
                quantosClocks <= quantosClocks + 1;
            end if;
            vezes := vezes - 1;
        end if;
    end process p1;
----------------------------------------------------------------------------------------------------    
    p0: process (clk, eventoContador2)
    begin
        contadorControle <= contadorControle + 1; -- responsavel pela valoracao de enable2
        -- Se resetou, atualiza valor de a para ativar/desativar enable2
        if (rst = '1') then
            contadorControle <= -1;
        end if;
    end process p0;
----------------------------------------------------------------------------------------------------    
    p2: process (clk)
        variable in_2: integer;
        variable soma_comeca: integer;
        variable var, para_saber: std_logic;
        variable tmp, enable2_variable: std_logic := '0';
        variable c: integer := 0;
        -------------------------------------------
        variable ARQ_LINE: LINE;
        variable tb_line_arq: string(1 to 200);
        variable temp: std_logic_vector((tb_line_arq'length-1) downto 0);
        variable tb_code: boolean;
        variable tb_i, tb_address_flag: integer;
    begin
        -- se tiver resetado, pega o valor da media para dar como entrada
        -- se nao resetou, entao pega novo valor de entrada
        if (resetando = '0' and vaiResetar = '0') then
            -- Se clk = '1' entao tem um novo valor de entrada -------------------------------------
            if (clk = '1') then        
                enable <= '1'; -- Informa que os calculos devem ser feitos porque existe uma entrada
                -- Verifica se eh o primeiro valor de entrada --------------------------------------
                if (contadorControle < 0) then
                    enable2 <= '0';
                    enable2_variable := '0';
                else
                    enable2 <= '1';
                    para_saber := '1'; -- para quando resetar, entrar no if abaixo na 1a iteracao
                    enable2_variable := '1';
                end if;
                ------------------------------------------------------------------------------------
                -- Se resetou e eh a primeira vez aqui depois disso, soma recebe o valor da media de
                -- antes de resetar
                if (contadorControle = -1 and para_saber = '1') then
                    soma_comeca := resInteiro; -- deve ser o valor da media de quando resetou
                    tmp := '1'; -- nao vai ler novo valor
                    enable2_variable := '1';
                end if;
                ------------------------------------------------------------------------------------
                -- LEITURA DE VALOR A PARTIR DO ARQUIVO
                -- Se tmp = '0' entao nao foi resetado, pega novo valor de entrada
                if (tmp = '0') then
                    if (not(endfile(ARQ))) then -- se nao eh o fim do arquivo
                        readline(ARQ, ARQ_LINE); -- le a linha do arquivo
                        c := ARQ_LINE'length; -- descobre comprimento da linha
                        read(ARQ_LINE, tb_line_arq(1 to ARQ_LINE'length)); -- le conteudo para um
                                                                           -- vetor de string
                        temp := to_std_logic_vector(tb_line_arq); -- substitui o for
                        in_2 := to_integer(unsigned(temp((tb_line_arq'length-1) downto 
                                                                          (tb_line_arq'length-c))));
-----------------------------------------------------------------------------------------                                                                           
--              for i in 1 to c loop -- ateh atingir o tamanho da linha, verifica cada   | 
--                                   -- caractere e, de acordo com ele, atribui 1 ou 0   |
--                  if (tb_line_arq(i) = '1') then                                       | 
--                      temp(c-i) := '1';                                                |                         
--                  elsif (tb_line_arq(i) = '0') then                                    | 
--                      temp(c-i) := '0';                                                | 
--                  end if;                                                              |             
--              end loop; -- temp terah o valor de entrada dado pelo arquivo em binario  | 
--              in_2 := to_integer(unsigned(temp(c-1 downto 0))); -- converte pra inteiro|
-----------------------------------------------------------------------------------------
                    end if;
                ------------------------------------------------------------------------------------
                    -- se cont = '0' entao a soma deve comecar com o valor de entrada, porque nao 
                    -- tem nada somado ainda (soh acontece no inicio)
                    if (cont = '0') then
                        soma_comeca := in_2;
                        cont <= '1'; -- isso vai fazer mudar o valor de cont
                    -- se contador eh diferente de zero, entao jah foram calculados alguns valores e
                    -- a soma deles deve ser levada em consideracao
                    else
                        soma_comeca := soma_comeca + in_2;
                    end if;
                    --------------------------------------------------------------------------------                    
                end if;
                somaDosValores <= soma_comeca;
                -- Se valor da soma de todos os valores estah dentro do limite ---------------------
                if (soma_comeca <= limite) then
                    -- Se resetou antes, entao in_1 pega o valor que a media tinha antes de resetar
                    if (tmp = '1') then
                        in_1 <= soma_comeca;
                    -- Senao pega o valor de entrada, normalmente ----------------------------------
                    else
                        in_1 <= in_2;
                    end if;
                    --------------------------------------------------------------------------------
                    tmp := '0'; -- para poder pegar novo valor (se puder) depois
                    rst <= '0'; -- indica que nao vai resetar
                -- Se o valor da soma ultrapassa um certo limite, entao reseta ---------------------
                else
                    vaiResetar <= '0';
                    resetando <= '1';
                    soma_comeca := 0;
                    eventoContador2 <= not(eventoContador2); -- serve para deixar a com novo valor
                end if;
                ------------------------------------------------------------------------------------
            -- Variando valor do enable ------------------------------------------------------------
            else -- (clk = '0') then
                enable <= '0';
            end if;
            ----------------------------------------------------------------------------------------
        -- Se estah resetando ----------------------------------------------------------------------
        elsif (resetando = '1' and vaiResetar = '0') then
            if (clk = '1') then
                enable <= '1';
                vaiResetar <= '1';
                resetando <= '0';
            else -- clk = '0'
                enable <= '0';
            end if;
        -- Continua resetando ----------------------------------------------------------------------
        elsif (resetando = '0' and vaiResetar = '1') then
            if (clk = '1') then
                enable <= '1';
                vaiResetar <= '0';
            else -- clk = '0'
               rst <= '1';
               enable <= '0';
            end if;
        end if;
        --------------------------------------------------------------------------------------------
    end process p2;
----------------------------------------------------------------------------------------------------        
    -- Transformando a media (que estah no padrao IEEE 754 em inteiro)
    p3: process (vaiResetar) -- resetando , 1
        variable saida, resultado, vetor: std_logic_vector(31 downto 0);
        variable expoente: std_logic_vector(7 downto 0);
        variable mantissa: std_logic_vector(22 downto 0);
        variable sinal: std_logic;
        variable expInteiro, deslocar, comprimentoVetor: integer;
        variable int: integer;
        --------------------------      
        variable ARQ_LINE: LINE;
        variable tb_line_arq: string(1 to 200);
    begin
        if (vaiResetar = '0') then
            -- Processo analogo ao realizado a mao
            vetor := "00000000000000000000000000000000";
            saida := out_1;
            sinal := saida(31);
            expoente := saida(30 downto 23);
            mantissa := saida(22 downto 0);
            expInteiro := to_integer(unsigned(expoente));
            deslocar := expInteiro - 127;
            resultado(31) := '1';
            resultado(30 downto (31-deslocar)) := mantissa(22 downto (23-deslocar));
            comprimentoVetor := resultado(31 downto (31 - deslocar))'length;
            vetor(comprimentoVetor-1 downto 0) := resultado(31 downto (31 - deslocar));
            resInteiro <= to_integer(unsigned(vetor));
            int := to_integer(unsigned(vetor));
            write(ARQ_LINE, str(int)&" "&str(quantosClocks));
            writeline(ARQ2, ARQ_LINE);
--          print(ARQ2, str(int)&" "&str(int));
        end if;
    end process p3;
end t_arq_m;
