-- Realiza a divisao e multiplicacao

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity div is
port ( I2: in std_logic_vector(31 downto 0);
		I3: in integer;
		enable: in std_logic;
		clk: in std_logic;
		O2: out std_logic_vector(31 downto 0)
	);
end div;

architecture arq_div of div is
	component componente_inicial is
	port (E1: in integer;
	        en: in std_logic;
			Clock: in std_logic;
			S1: out std_logic_vector(31 downto 0)
			);
	end component;
	component componente_divide is
	port (E2: in std_logic_vector(31 downto 0);
			E3: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S2: out std_logic_vector(24 downto 0)
			);
	end component;
	component componente_operaexp is
	port (E4: in std_logic_vector(31 downto 0);
			E5: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S3: out std_logic_vector(7 downto 0)
			);
	end component;
	component componente_normdiv is
    port (E6: in std_logic_vector(33 downto 0);
    		Clock: in std_logic;
            S5: out std_logic_vector(7 downto 0);
            S6: out std_logic_vector(24 downto 0)
    	);
	end component;
	component componente_multmant is
	port (E10: in std_logic_vector(31 downto 0);
			E11: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S5: out std_logic_vector(47 downto 0)
			);
	end component;
	component componente_somaexp is
	port (E12: in std_logic_vector(31 downto 0);
			E13: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			S6: out std_logic_vector(7 downto 0)
			);
	end component;
	component componente_normres is
	port (E14: in std_logic_vector(47 downto 0);  -- resultado de multmant
			E15: in std_logic_vector(7 downto 0);  -- resultado de somaexp
			E16: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			E17: in std_logic_vector(31 downto 0);  -- apenas para pegar o sinal
			Clock: in std_logic;
			S7: out std_logic_vector(31 downto 0)
			);
	end component;
	component componente_regv is
	port (Ev: in std_logic_vector(31 downto 0);
			Clock: in std_logic;
			Sv: out std_logic_vector(31 downto 0)
			);
	end component;
	signal f1: std_logic_vector(31 downto 0);
	signal f2: std_logic_vector(31 downto 0);
	signal f3: std_logic_vector(24 downto 0); 
	signal f4: std_logic_vector(7 downto 0);
	signal f5: std_logic_vector(0 downto 0);
	signal f7: std_logic_vector(47 downto 0);
	signal f8: std_logic_vector(7 downto 0);
	signal f9, f12, resdiv: std_logic_vector(31 downto 0);
    signal f10: std_logic_vector(7 downto 0);
    signal f11: std_logic_vector(24 downto 0);
    signal um: std_logic_vector(31 downto 0) := "00111111100000000000000000000000";
    signal teste: std_logic_vector(33 downto 0);
begin
	inicial1: componente_inicial port map(E1 => I3, en => enable, Clock => clk, S1 => f2);
    divmant1: componente_divide port map(E2 => um, E3 => f2, Clock => clk, S2 => f3);
	subtexp1: componente_operaexp port map(E4 => um, E5 => f2, Clock => clk, S3 => f4);
    teste <= '0' & f4 & f3;
	normdiv1: componente_normdiv port map(E6 => teste, Clock => clk, S5 => f10, S6 => f11);
    resdiv <= '0' & f10 & f11(23 downto 1);
	reg2: componente_regv port map(Ev => I2, Clock => clk, Sv => f1); 
    reg3: componente_regv port map(Ev => resdiv, Clock => clk, Sv => f9);
--    reg4: componente_regv port map(Ev => f1, Clock => clk, Sv => f12);
    multmant1: componente_multmant port map(E10 => f1, E11 => f9, Clock => clk, S5 => f7);
	somaexp1: componente_somaexp port map(E12 => f1, E13 => f9, Clock => clk, S6 => f8);
	normres1: componente_normres port map(E14 => f7, E15 => f8, E16 => f1, E17 => f9, Clock => clk, S7 => O2);
end arq_div;
