-- O valor resultante neste componente e' enviado para um multiplexador que ira decidir se usa este
-- valor para acumular as demais entradas que forem propostas

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity componente_soma4 is
port (SaidaSoma: in std_logic_vector(33 downto 0);
	    Clk: in std_logic;
	    O_fim1: out std_logic_vector(31 downto 0)
    );
end componente_soma4;

architecture a_soma4 of componente_soma4 is
    signal v1, v2: std_logic_vector(31 downto 0);
    signal Mant_1, Mant_3, Mant_4: std_logic_vector(24 downto 0) := "0000000000000000000000000";
    signal Mant_2: std_logic_vector(22 downto 0) := "00000000000000000000000";
    signal Exp_1, Exp_2, Exp_3, Exp_4: std_logic_vector(7 downto 0) := "00000000";
    signal Sinal_1, Sinal_2, Sinal_3, Sinal_4: std_logic := '0';  
    signal a, b, c, d, e, f: std_logic := '0';
begin
	p1: process(SaidaSoma)
		variable ExpNormFim: std_logic_vector(7 downto 0) := "00000000";
		variable SinalNormFim: std_logic := '0';
		variable MantNormFim: std_logic_vector(24 downto 0) := "0000000000000000000000000";
	begin
		-- Separa dados da soma
		SinalNormFim := SaidaSoma(33);
		ExpNormFim(7 downto 0) := SaidaSoma(32 downto 25);
		MantNormFim(24 downto 0) := SaidaSoma(24 downto 0);
		-- Deixa resultado normalizado de acordo com valores da mantissa
		if (MantNormFim(23) = '0' and MantNormFim(24) = '0') then
		    Mant_1 <= MantNormFim;
		    Exp_1 <= ExpNormFim;
		    Sinal_1 <= SinalNormFim;
		    e <= not(e);
		elsif(MantNormFim(24) = '1' and MantNormFim(23) = '1') then
		    Mant_2 <= '1' & MantNormFim(22 downto 1);
		    Exp_2 <= ExpNormFim;
		    Sinal_2 <= SinalNormFim;
		    d <= not(d);
		elsif(MantNormFim(24) = '1' and MantNormFim(23) = '0') then
            Mant_2 <= '0' & MantNormFim(22 downto 1); 
            Exp_2 <= ExpNormFim;
            Sinal_2 <= SinalNormFim;
            d <= not(d);
		else -- MantNormFim(24) = '0' and MantNormFim(23) = '0'
			Mant_2 <= MantNormFim(22 downto 0);
			Exp_2 <= ExpNormFim;
			Sinal_2 <= SinalNormFim;
			d <= not(d);
		end if;
    end process p1;
    
    p2: process(Mant_2, d)
    begin
        a <= not(a);
        v1 <= Sinal_2 & Exp_2 & Mant_2;
    end process p2;
    
    p4: process(Mant_3, f)
    begin
        b <= not(b);
        v2 <= Sinal_3 & Exp_3 & Mant_3(22 downto 0);
    end process p4;
    
    p5: process(v1, v2, a, b)
    begin
        if (rising_edge(a) or falling_edge(a)) then
            O_fim1 <= v1;
        elsif (rising_edge(b) or falling_edge(b)) then
            O_fim1 <= v2;
        end if;
    end process p5;
    
    p3: process(Mant_1, Exp_1, e)
        variable Mant_tmp: std_logic_vector(24 downto 0);
        variable Exp_tmp: std_logic_vector(7 downto 0);
        variable Sinal_tmp: std_logic;
    begin
        Mant_tmp := Mant_1;
        Exp_tmp := Exp_1;
        Sinal_tmp := Sinal_1;     
        if (Mant_tmp(23) = '0' and not(Mant_tmp(22 downto 0) = "00000000000000000000000")) then
            Exp_tmp := Exp_tmp - "00000001";
            Mant_tmp(23 downto 0) := Mant_tmp(22 downto 0) & '0';
        end if;
        Exp_4 <= Exp_tmp;
        Mant_4 <= Mant_tmp;      
        Sinal_4 <= Sinal_tmp;
        c <= not(c);
    end process p3;
    
    p6: process(Mant_4, Exp_4, Mant_3, Exp_3, c)
        variable Mant_tmp: std_logic_vector(24 downto 0);
        variable Exp_tmp: std_logic_vector(7 downto 0);
        variable Sinal_tmp: std_logic;
    begin
        if (rising_edge(c) or falling_edge(c)) then
            Mant_tmp := Mant_4;
            Exp_tmp := Exp_4;
            Sinal_tmp := Sinal_4;    
        else
            Mant_tmp := Mant_3;
            Exp_tmp := Exp_3;
            Sinal_tmp := Sinal_3;
        end if;  
        if (Mant_tmp(23) = '0' and not(Mant_tmp(22 downto 0) = "00000000000000000000000")) then
            Exp_tmp := Exp_tmp - "00000001";
            Mant_tmp(23 downto 0) := Mant_tmp(22 downto 0) & '0';
        end if;
        Exp_3 <= Exp_tmp;
        Mant_3 <= Mant_tmp;      
        Sinal_3 <= Sinal_tmp;
        f <= not(f);  
    end process p6;
end a_soma4;
