-- Recebe o valor para ser acumulado e o valor que ja esta acumulado e os desloca, de forma a ser
-- possivel a soma destes valores atraves do algoritmo utilizado
-- Modifica valor do expoente e da mantissa, caso haja necessidade (para que o valor do
-- expoente dos 2 operandos seja igual)
--		Ex.:
--		0 01111101 00000000000000000000000 (original value)
--		0 01111110 10000000000000000000000 (shifted 1 place)
--		0 01111111 01000000000000000000000 (shifted 2 places)
--    

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

-- Uma entrada e' o valor da soma (I2_1) e a outra o novo valor a ser somado (I2)
entity componente_soma2 is
port (I2: in std_logic_vector(31 downto 0);
		I2_1: in std_logic_vector(31 downto 0);
		Cont: in integer;
		Clk: in std_logic;
		SaidaShiftA: out std_logic_vector(32 downto 0);
		SaidaShiftB: out std_logic_vector(32 downto 0)
	);
end componente_soma2;

architecture a_soma2 of componente_soma2 is
    signal ExpShiftA, ExpShiftB: std_logic_vector(7 downto 0) := "00000000";
    signal MantShiftA, MantShiftB, Mant_resA, Mant_resB: std_logic_vector(23 downto 0) := "000000000000000000000000";
    signal diferencaExps, diferencaExps2, diferencaExps3, testeSignal: std_logic_vector(7 downto 0) := (others => 'X');
    signal SinalShiftA, SinalShiftB: std_logic := '0';
	signal resExp: std_logic_vector(7 downto 0) := "00000000";
	signal tmp_1, prim: std_logic := '0';
	signal tmp_2, tmp_3, ativa2, ativa3, teste: integer := 0;
	signal a, b, c, d, e, ativa: std_logic := '0';
begin
	p1: process(Cont, I2)
	begin
		-- Separa dados de A
		SinalShiftA <= I2_1(31);
		ExpShiftA(7 downto 0) <= I2_1(30 downto 23);
		MantShiftA(23 downto 0) <= '1' & I2_1(22 downto 0);
		-- Separa dados de B
		SinalShiftB <= I2(31);
		ExpShiftB(7 downto 0) <= I2(30 downto 23);
		MantShiftB(23 downto 0) <= '1' & I2(22 downto 0);
		ativa3 <= ativa3 + 1;
	end process p1;
		
	-- Calcula a diferenca entre os expoentes para poder calcular a mantissa
	p4: process(ExpShiftA, ExpShiftB, ativa3)
	begin
		-- Verifica qual e' o maior expoente, calcula a diferenca entre eles, o expoente do resultado e' o valor do maior expoente      
		if (to_integer(unsigned(ExpShiftA)) < to_integer(unsigned(ExpShiftB))) then
		    ativa2 <= ativa2 + 1;
			diferencaExps <= ExpShiftB - ExpShiftA;
			resExp <= ExpShiftB;
		elsif (to_integer(unsigned(ExpShiftA)) > to_integer(unsigned(ExpShiftB))) then
		    ativa2 <= ativa2 + 1;
            diferencaExps <= ExpShiftA - ExpShiftB;
            resExp <= ExpShiftA;
 		else -- Se o valor dos expoentes e' igual
 		    diferencaExps <= "00000000";
 		    resExp <= ExpShiftA; -- Poderia ser qualquer um
 		    ativa2 <= ativa2 + 1;
		end if;
	end process p4;
	
	-- Decrementa o valor da diferenca entre expoentes
	p2: process(diferencaExps, ativa2)
	    variable diferencaExps_var: std_logic_vector(7 downto 0);
	    variable acaba: std_logic;
	begin
        diferencaExps_var := diferencaExps;
        acaba := '0';
        prim <= not(prim);
        -- Se (diferencaExps = "00000001") so' vai deslocar uma vez, esse if garante isso 
	    if (diferencaExps = "00000001") then
	        diferencaExps_var := "00000001";
	        if (acaba = '0') then
	            ativa <= not(ativa);
	        end if;
	        acaba := '1';
	    end if;
        if (not(diferencaExps_var = "00000000") and (acaba = '0')) then
    	    diferencaExps_var := diferencaExps_var - "00000001";
        end if;
	    diferencaExps3 <= diferencaExps_var;
	    tmp_1 <= acaba;
	    a <= not(a);
	end process p2;
	
    -- Decrementa o valor da diferenca entre expoentes
	p5: process(diferencaExps2, b)
	    variable diferencaExps_var: std_logic_vector(7 downto 0);
	    variable acaba: std_logic;
	begin
	    if (rising_edge(b) or falling_edge(b)) then
	        diferencaExps_var := diferencaExps3;
	    else
	        diferencaExps_var := diferencaExps2;
	    end if;
        if (not(diferencaExps_var = "00000000") and (tmp_1 = '0')) then
    	    diferencaExps_var := diferencaExps_var - "00000001";
        end if;
	    diferencaExps2 <= diferencaExps_var;
	    -- Como ocorreu evento em d (nao deve mais deslocar mantissa - ver abaixo), impede que isso aconteca
	    if (rising_edge(d) or falling_edge(d)) then
	        e <= not(e);
	    end if;
	    -- Se e' a ultima vez que deve haver deslocamento da mantissa
	    if (diferencaExps2 = 0) then
	        d <= not(d);
	    end if;
	    c <= not(c);
	end process p5;
	
	-- Para definir o valor das mantissas, de acordo com a diferenca entre os expoentes
	p3: process(diferencaExps2, diferencaExps3, ativa, a, c)
	    variable MantA_var, MantB_var: std_logic_vector(23 downto 0) := "000000000000000000000000";
	begin
	    if ((to_integer(unsigned(diferencaExps2)) >= 0) or (to_integer(unsigned(diferencaExps3)) >= 0)) then
	        if (to_integer(unsigned(ExpShiftA)) < to_integer(unsigned(ExpShiftB))) then
	            if (((rising_edge(a) or falling_edge(a))) ) then -- or (rising_edge(prim) or falling_edge(prim))
	                MantA_var := MantShiftA;
	                tmp_3 <= tmp_3 + 1;
    	        else
    	            MantA_var := Mant_resA;
	            end if;
	            tmp_2 <= tmp_2 + 1;
	            -- Se ainda nao e' hora de parar de deslocar porque a diferenca nao e' zero, desloca
	            if ( not(rising_edge(e) or falling_edge(e)) ) then
	                MantA_var(23 downto 0) := '0' & MantA_var(23 downto 1);
	                Mant_resA <= MantA_var;
	                Mant_resB <= MantShiftB;
	            end if;
	        elsif (to_integer(unsigned(ExpShiftA)) > to_integer(unsigned(ExpShiftB))) then
	            if (rising_edge(a) or falling_edge(a)) then -- or (rising_edge(prim) or falling_edge(prim))
	                MantB_var := MantShiftB;
	                tmp_3 <= tmp_3 + 1;
    	        else
    	            MantB_var := Mant_resB;
	            end if;
	            -- Se ainda nao e' hora de parar de deslocar porque a diferenca nao e' zero, desloca
	            if ( not(rising_edge(e) or falling_edge(e)) ) then
	                MantB_var(23 downto 0) := '0' & MantB_var(23 downto 1);
	                Mant_resB <= MantB_var;
	                Mant_resA <= MantShiftA;
	            end if;
	        elsif ((to_integer(unsigned(diferencaExps3)) = 0)) then
	            Mant_resA <= MantShiftA;
	            Mant_resB <= MantShiftB;
	        end if;    
	    end if;
	    -- Se deslocou uma unica vez apenas, mas precisa deslocar mais. E' uma forma de chamar o processo gerando evento em b
	    if ((rising_edge(a) or falling_edge(a)) and (not(rising_edge(ativa) or falling_edge(ativa))) and (to_integer(unsigned(diferencaExps3)) > 0)) then
	        b <= not(b);
	        teste <= teste + 1;
	    end if; 
	end process p3;
	
	SaidaShiftA <= SinalShiftA & resExp & Mant_resA;
    SaidaShiftB <= SinalShiftB & resExp & Mant_resB;
end a_soma2;
