-- Faz a soma de varios valores - soma acumulativa
-- Recebe um valor inteiro e o transforma em std_logic_vector, formato ponto flutuante padrao IEEE 754
-- Tambem calcula um contador, que sera usado para realizar o calculo da media futuramente

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity componente_soma1 is
port (  I1: in integer;
        en: in std_logic;
		Clk: in std_logic;
		rst: in std_logic;
		O1: out std_logic_vector(31 downto 0);
		contador: out integer;
		enab: out std_logic
	);
end componente_soma1;

architecture a_soma1 of componente_soma1 is
    signal cont: integer := 0;
    signal enable: std_logic := '0';
begin
	process(en)
		variable campos, mantissa, valorExpoente: integer;
		variable MantN: std_logic_vector(22 downto 0) := "00000000000000000000000";
		variable ExpN: std_logic_vector(7 downto 0) := "00000000";
		variable Valor, SaidaNorm: std_logic_vector(31 downto 0) := "00000000000000000000000000000000";
	begin
	    if (rst = '1') then
	        cont <= 0;
	        enable <= '0';
	    end if;
	    if (en = '1' and rst = '0') then
			-- Para saber quantos bits ocupa na mantissa
			case I1 is
				when 0 to 1 =>
					campos := 1;
				when 2 to 3 =>
					campos := 2;
					mantissa := 1;
				when 4 to 7 =>
					campos := 3;
					mantissa := 2;
				when 8 to 15 =>
					campos := 4;
					mantissa := 3;
				when 16 to 31 =>
					campos := 5;
					mantissa := 4;
				when 32 to 63 =>
					campos := 6;
					mantissa := 5;
				when 64 to 127 =>
					campos := 7;
					mantissa := 6;
				when 128 to 255 =>
					campos := 8;
					mantissa := 7;
				when 256 to 511 =>
					campos := 9;
					mantissa := 8;
				when 512 to 1023 =>
					campos := 10;
					mantissa := 9;
				when 1024 to 2047 =>
					campos := 11;
					mantissa := 10;
				when 2048 to 4095 =>
					campos := 12;
					mantissa := 11;
				when 4096 to 8191 =>
					campos := 13;
					mantissa := 12;
				when 8192 to 16383 =>
					campos := 14;
					mantissa := 13;
				when 16384 to 32767 =>
					campos := 15;
					mantissa := 14;
				when 32768 to 65535 =>
					campos := 16;
					mantissa := 15;
				when 65536 to 131071 =>
					campos := 17;
					mantissa := 16;
				when 131072 to 262143 =>
					campos := 18;
					mantissa := 17;
				when 262144 to 524287 =>
					campos := 19;
					mantissa := 18;
				when 524288 to 1048575 =>
					campos := 20;
					mantissa := 19;
				when 1048576 to 2097151 =>
					campos := 21;
					mantissa := 20;
				when 2097152 to 4194303 =>
					campos := 22;
					mantissa := 21;
				when 4194304 to 8388607 =>
					campos := 23;
					mantissa := 22;
				when 8388608 to 16777215 =>
					campos := 24;
					mantissa := 23;	
				when others =>
					campos := 24;
					mantissa := 23;
			end case;
			-- Converte numero inteiro para std_logic_vector
			-- Ex.: 3 = 11 -> campos = 2 & mant = 1 -> 1.1
			--                                           ^
			Valor := std_logic_vector(to_unsigned(I1, 32));
			if (mantissa > 0) then
				MantN(22 downto 0) := "00000000000000000000000";
				-- No caso do exemplo, MantN(22) := Valor(0); -> 1
				MantN(22 downto (23 - mantissa)) := Valor((mantissa-1) downto 0);
				-- valorExpoente := 128;
				valorExpoente := 127 + mantissa;
				-- Transforma o valor de valorExpoente em um vetor de 8 posicoes -> 10000000
				ExpN := std_logic_vector(to_unsigned(valorExpoente, 8));
				-- 0 & 10000000 & 10000000000000000000000
				O1 <= '0' & ExpN & MantN;				
			elsif (mantissa = 0) then
				if (I1 = 0) then
					MantN(22 downto 0) := "00000000000000000000000";
					ExpN(7 downto 0) := "00000000";
					O1 <= '0' & ExpN & MantN;
				elsif (I1 = 1) then
					MantN(22 downto 0) := "00000000000000000000000";
					ExpN(7 downto 0) := "01111111";
					O1 <= '0' & ExpN & MantN;		
				end if;
			end if;
			cont <= cont + 1;
			enable <= not(enable);
		end if;
	end process;
	enab <= enable;
	contador <= cont;
end a_soma1;
