-- Faz subtracao dos expoentes e informa o valor que o expoente tera'

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_operaexp is
port (E4: in std_logic_vector(31 downto 0);
		E5: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S3: out std_logic_vector(7 downto 0)
		);
end componente_operaexp;
		
architecture a_operaexp of componente_operaexp is
  signal tmp: std_logic_vector(7 downto 0);
begin
	process(E5)
		variable SinalA, SinalB: std_logic;
		variable ExpA, ExpB, CentoEVinteESete: std_logic_vector(7 downto 0);
		variable MantA, MantB: std_logic_vector(22 downto 0);
		variable subtrai: integer;
		variable Subt1, Subt2, SubtFinal: std_logic_vector(7 downto 0);
		variable ValorInt, ValorInt2, ValorInt3: integer;
	begin
		tmp <= "00000000";
		--
		CentoEVinteESete := "01111111";
		-- Subtracoes
		--		   10000100         01111111  
		--		 - 01111111       - 00111100   
 				  ----------       ----------
		--		   00000101         01000011
		--		exp verdadeiro   exp verdadeiro
		--		     e' 5.           e' -67
		Subt1 := E4(30 downto 23) - CentoEVinteESete;
		Subt2 := CentoEVinteESete - E5(30 downto 23);
		ValorInt := to_integer(signed(Subt2)) * (-1);
		-- Subtrai expoentes verdadeiros
		ValorInt2 := to_integer(signed(Subt1)) - ValorInt;
		-- Soma 127 ao valor anteriormente calculado
		ValorInt3 := ValorInt2 + 127;
		-- Resultado		
		tmp <= std_logic_vector(to_signed(ValorInt3, 8));
    end process;
    S3 <= tmp;
end a_operaexp;
