-- Normaliza o resultado da divisao

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity componente_normdiv is
port (E6: in std_logic_vector(33 downto 0);
		Clock: in std_logic;
		S5: out std_logic_vector(7 downto 0);
		S6: out std_logic_vector(24 downto 0) 
	);
end componente_normdiv;
		
architecture a_normdiv of componente_normdiv is
    signal tmp, v1, v2, oi: std_logic_vector(31 downto 0);
    signal Mant_1, Mant_2, Mant_3, Mant_4: std_logic_vector(24 downto 0) := "XXXXXXXXXXXXXXXXXXXXXXXXX";
    signal Exp_1, Exp_2, Exp_3, Exp_4: std_logic_vector(7 downto 0) := "XXXXXXXX"; 
    signal Sinal_1, Sinal_2, Sinal_3, b, c: std_logic := '0'; 
    signal a: std_logic := '0';
begin
	p1: process(E6)
		variable SinalA, SinalB: std_logic; 
	begin
		Exp_2(7 downto 0) <= E6(32 downto 25);
		Mant_2(24 downto 0) <= E6(24 downto 0);
		Sinal_3 <= E6(33);
	end process p1;

	-- Define valor de mantissa e expoente
	-- Ate que Mant(24) seja 1 ou nao tenha 1 na mantissa
	p2: process(Exp_2, Mant_2)
	    variable Exp_tmp: std_logic_vector(7 downto 0) := "XXXXXXXX";
	    variable Mant_tmp: std_logic_vector(24 downto 0) := "XXXXXXXXXXXXXXXXXXXXXXXXX";
	begin
	    Exp_tmp := Exp_2;
	    Mant_tmp := Mant_2;
	    if (Mant_tmp(24) = '0' and not(Mant_tmp(24 downto 0) = "0000000000000000000000000")) then
	        Mant_tmp(24 downto 0) := Mant_tmp(23 downto 0) & '0';
	        Exp_tmp(7 downto 0) := Exp_tmp(7 downto 0) - "00000001";
	    end if;
	    Exp_4 <= Exp_tmp;
	    Mant_4 <= Mant_tmp;
	    a <= not(a);
	end process p2;
	
	-- Define valor de mantissa e expoente
	-- Ate que Mant(24) seja 1 ou nao tenha 1 na mantissa
	p6: process(Exp_4, Mant_4, Mant_3, Exp_3)
	    variable Exp_tmp: std_logic_vector(7 downto 0) := "XXXXXXXX";
	    variable Mant_tmp: std_logic_vector(24 downto 0) := "XXXXXXXXXXXXXXXXXXXXXXXXX";
	begin
	    if (rising_edge(a) or falling_edge(a)) then
    	    Exp_tmp := Exp_4;
	        Mant_tmp := Mant_4;	    
	    else
	        Exp_tmp := Exp_3;
	        Mant_tmp := Mant_3;
	    end if;
	    if (Mant_tmp(24) = '0' and not(Mant_tmp(24 downto 0) = "0000000000000000000000000")) then
	        Mant_tmp(24 downto 0) := Mant_tmp(23 downto 0) & '0';
	        Exp_tmp(7 downto 0) := Exp_tmp(7 downto 0) - "00000001";
	    end if;
	    Exp_3 <= Exp_tmp;
	    Mant_3 <= Mant_tmp;
	end process p6;

    S5 <= Exp_3; 
    S6 <= Mant_3;
end a_normdiv;
