-- Faz a divisao das mantissas

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity componente_divide is
port (E2: in std_logic_vector(31 downto 0);
		E3: in std_logic_vector(31 downto 0);
		Clock: in std_logic;
		S2: out std_logic_vector(24 downto 0)
		);
end componente_divide;
		
architecture a_divide of componente_divide is
    signal tmp, tmp_2, tmp_3, tmp_4: std_logic_vector(24 downto 0);
    signal a, b, c, d, e, f, g, h, i: std_logic := '0';
    signal ativa1, Zero, conta, ResAnt, limiteAnt, algo: integer := 0;
    signal SinalA, SinalB: std_logic;
	signal ExpA, ExpB: std_logic_vector(7 downto 0);
	signal MantA, MantB, MantA_p3, MantA_3, MantA_4: std_logic_vector(24 downto 0);
	signal Res_std, Res_std2, Res_std_1: std_logic_vector(24 downto 0) := "XXXXXXXXXXXXXXXXXXXXXXXXX";
begin
	p1: process(E3) 
	begin
		-- Inicializa resultado com zero
		tmp <= "0000000000000000000000000";
		-- Separa dados de A -- 1
		d <= not(d);
		SinalA <= E2(31);
		ExpA(7 downto 0) <= E2(30 downto 23);
		MantA(24 downto 0) <= "01" & E2(22 downto 0);
		-- Separa dados de B -- contador
		SinalB <= E3(31);
		ExpB(7 downto 0) <= E3(30 downto 23);
		MantB(24 downto 0) <= "01" & E3(22 downto 0);
	end process p1;

    p2: process(MantB, d)
		variable limite, cont, Res, ja_foi_um_zero: integer;
		variable SinalA_1: std_logic;
		variable ExpA_1: std_logic_vector(7 downto 0);
		variable MantA_1, MantB_1: std_logic_vector(24 downto 0); 
        variable tmp_1: std_logic_vector(24 downto 0);
    begin
        cont := 24;
        limite := 24;
        ja_foi_um_zero := 0;
        Res := 1;
        MantA_1 := MantA;
        MantB_1 := MantB;
        tmp_1 := tmp;
        if (not(Res = 0) and (limite > 0)) then
            Res := to_integer(unsigned(MantA_1)) - to_integer(unsigned(MantB_1));
			Res_std <= MantA_1 - MantB_1;
			if (Res < 0) then -- nao consegue dividir (o valor de MantB eh maior que o de MantA)
				MantA_1(24 downto 0) := MantA_1(23 downto 0) & '0';			
				if (ja_foi_um_zero = 0) then
					tmp_1(cont) := '0';
					cont := cont - 1;
					ja_foi_um_zero := 1;
				end if;
				MantA_3 <= MantA_1;
				b <= not(b);
				Res := 1;
			else
			    ja_foi_um_zero := 0;
				tmp_1(cont) := '1';
				cont := cont - 1;
				a <= not(a);
			end if;
			limite := limite - 1;
        end if;
        conta <= cont;
        tmp_3 <= tmp_1;
        ResAnt <= Res;
        limiteAnt <= limite;
        Zero <= ja_foi_um_zero;
        f <= not(f);
    end process p2;    
    
    p5: process(b, e, h)
		variable limite, cont2, ja_foi_um_zero2, Res: integer := 0;
		variable SinalA_1: std_logic;
		variable ExpA_1: std_logic_vector(7 downto 0);
		variable MantA_1, MantB_1: std_logic_vector(24 downto 0); 
        variable tmp_1: std_logic_vector(24 downto 0);
    begin
        if (rising_edge(b) or falling_edge(b)) then
            ja_foi_um_zero2 := Zero;
            cont2 := conta;
            Res := ResAnt;
            limite := limiteAnt;
            tmp_1 := tmp_3;
        else
            tmp_1 := tmp_4; 
        end if;
        if ((rising_edge(b) or falling_edge(b)) or (rising_edge(h) or falling_edge(h))) then
            MantA_1 := MantA_3;
        elsif (rising_edge(h) or falling_edge(h)) then
            MantA_1 := MantA_4;
        elsif (rising_edge(e) or falling_edge(e)) then
            MantA_1 := MantA_p3;
        end if;
        MantB_1 := MantB;
        if (not(Res = 0) and (limite > 0)) then
            Res := to_integer(unsigned(MantA_1)) - to_integer(unsigned(MantB_1));
			Res_std2 <= MantA_1 - MantB;
			if (Res < 0) then -- nao consegue dividir (o valor de MantB eh maior que o de MantA)
				MantA_1(24 downto 0) := MantA_1(23 downto 0) & '0';			
				if (ja_foi_um_zero2 = 0) then
					tmp_1(cont2) := '0';
					cont2 := cont2 - 1;
					ja_foi_um_zero2 := 1;
				end if;
				MantA_4 <= MantA_1;
				h <= not(h);
				Res := 1;
			else
			    ja_foi_um_zero2 := 0;
				tmp_1(cont2) := '1';
				cont2 := cont2 - 1;
				i <= not(i);
			end if;
			limite := limite - 1;
        end if;
        tmp_4 <= tmp_1;
        g <= not(g);
    end process p5;   
    
    p7: process(tmp_3, tmp_4)
    begin
        if (rising_edge(f) or falling_edge(f)) then
            tmp_2 <= tmp_3;
        elsif (rising_edge(g) or falling_edge(g)) then
            tmp_2 <= tmp_4;
        end if;
    end process p7;
    
    p3: process(a, Res_std_1, ativa1, i)
        variable Res_std_tmp, Res_std_1_tmp: std_logic_vector(24 downto 0);
    begin
        if (rising_edge(a) or falling_edge(a)) then
            Res_std_tmp := Res_std;
            Res_std_1_tmp := "XXXXXXXXXXXXXXXXXXXXXXXXX";
        elsif (rising_edge(i) or falling_edge(i)) then
            Res_std_tmp := Res_std2;
            Res_std_1_tmp := "XXXXXXXXXXXXXXXXXXXXXXXXX";
        else
            Res_std_tmp := Res_std_1;
            Res_std_1_tmp := Res_std_1;
        end if;
        if (Res_std_tmp(23) = '0' and (to_integer(unsigned(Res_std_tmp)) > 0)) then
            Res_std_tmp(24 downto 1) := Res_std_tmp(23 downto 0);
			Res_std_tmp(0) := '0';
        end if;
        if (Res_std_tmp = Res_std_1_tmp) then -- Se Res_std_tmp nao foi mudado no if anterior, entao nao vai mais usar esse processo, entao volta pro anterior
            MantA_p3(24 downto 0) <= Res_std_tmp(24 downto 0);
            e <= not(e);  
        end if;
        if (not(Res_std_tmp = Res_std_1_tmp)) then
            Res_std_1 <= Res_std_tmp;
            ativa1 <= ativa1 + 1;
        end if;
    end process p3;
    
    p10: process(MantA_p3, MantA_4, MantA_3, a, i, g)
    begin
        if (rising_edge(e) or falling_edge(e)) then
            S2 <= MantA_p3;
        elsif ((rising_edge(h) or falling_edge(h)) or (rising_edge(i) or falling_edge(i)))then
            S2 <= tmp_4;
        elsif (rising_edge(b) or falling_edge(b))then
            S2 <= tmp_3;
        else
            S2 <= tmp_2;
        end if;
    end process p10;
end a_divide;	
