-- Realiza a soma dos valores de entrada

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use std.textio.all;

entity acumulador is
port (entrada: in integer;
        enable: in std_logic;
        enable2: in std_logic;
		clk: in std_logic;
		rst: in std_logic;
		soma: out std_logic_vector(31 downto 0);
		contador: out integer;
		enableCont: out std_logic
	);
end acumulador;

architecture arq_acc of acumulador is
	component componente_soma1 is
    port (  I1: in integer;
            en: in std_logic;
		    Clk: in std_logic;
		    rst: in std_logic;
		    O1: out std_logic_vector(31 downto 0);
		    contador: out integer;
		    enab: out std_logic
	    );
	end component;
	component componente_soma2 is
	port (I2: in std_logic_vector(31 downto 0);
			I2_1: in std_logic_vector(31 downto 0);
			Cont: in integer;
			Clk: in std_logic;
			SaidaShiftA: out std_logic_vector(32 downto 0);
			SaidaShiftB: out std_logic_vector(32 downto 0)
		);
	end component;
	component componente_soma3 is
	port (I3: in std_logic_vector(32 downto 0);
			I4: in std_logic_vector(32 downto 0);
			Clk: in std_logic;
			SaidaSoma: out std_logic_vector(33 downto 0)
		);
	end component;
	component componente_soma4 is
	port (SaidaSoma: in std_logic_vector(33 downto 0);
			Clk: in std_logic;
			O_fim1: out std_logic_vector(31 downto 0)
		);
	end component;
	component reg is
    port (ck, rst: in std_logic;
           	D: in std_logic_vector(31 downto 0);
           	Q: out std_logic_vector(31 downto 0)
        );
    end component;
    component reg_umbit is
    port (ck, rst: in std_logic;
           	D: in std_logic;
           	Q: out std_logic
        );
    end component;
    component reg_int is
	port (ck, rst: in std_logic;
           	D: in integer;
           	Q: out integer
        );
    end component;
    component multiplexador is
	port (Seletor: in std_logic;
	        In1: in std_logic_vector(31 downto 0);
	        In2: in std_logic_vector(31 downto 0);
	        Out1: out std_logic_vector(31 downto 0)
        );
    end component;
	signal f1: std_logic_vector(31 downto 0) := "00000000000000000000000000000000";
	signal f2: std_logic_vector(31 downto 0);
	signal f3: std_logic_vector(32 downto 0); 
	signal f4: std_logic_vector(32 downto 0);
	signal f5: std_logic_vector(33 downto 0);
	signal f6: std_logic_vector(31 downto 0);
	signal f7: std_logic_vector(31 downto 0);
	signal f8: std_logic_vector(31 downto 0);	
--	signal zero: std_logic := '0';
	signal stmp1: std_logic_vector(31 downto 0);
	signal stmp2: std_logic_vector(31 downto 0);
	signal stmp3: integer;
	signal soma_retro: std_logic_vector(31 downto 0);
	signal saidaEn: std_logic;
	signal enab: std_logic;
	signal tmp_cont: integer;
begin
	norm: componente_soma1 port map(I1 => entrada, en => enable, Clk => clk, rst => rst, O1 => f2, contador => tmp_cont, enab => enab);
	mult: multiplexador port map(Seletor => enable2, In1 => f1, In2 => soma_retro, Out1 => f8);	
	reg1: reg port map(ck => clk, rst => rst, D => f2, Q => stmp1); -- novo valor
	reg2: reg port map(ck => clk, rst => rst, D => f8, Q => stmp2); -- valor do somatorio
	reg3: reg_int port map(ck => clk, rst => rst, D => tmp_cont, Q => stmp3); -- valor do contador
	reg4: reg_umbit port map(ck => clk, rst => rst, D => enab, Q => saidaEn); -- valor do enable que aciona a divisao
	shift: componente_soma2 port map(I2 => stmp1, I2_1 => stmp2, Cont => stmp3, Clk => clk, SaidaShiftA => f3, SaidaShiftB => f4);
	soma_1: componente_soma3 port map(I3 => f3, I4 => f4, Clk => clk, SaidaSoma => f5);
	norm_fim: componente_soma4 port map(SaidaSoma => f5, Clk => clk, O_fim1 => soma_retro);        
    soma <= soma_retro;
	contador <= stmp3;
	enableCont <= saidaEn;
end arq_acc;
